/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Filename:       readerComm.cpp
    Description:    Functions used to communicate with the TRF7970 eval bd.
                    Communication is by means of an SPI interface between
                    the nRF51-DK board (nRF51422 MCU) and the TRF7970 eval bd.
    Copyright (C)   2015 Gymtrack, Inc.
    Author:         Ron Clough
    Date:           2015-02-27

    Changes:
    Rev     Date        Who     Details
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    0.0     2015-02-27  RWC     Original version.

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*==========================================================================
Initialize the chipset ISO15693 and read UID:
1) Reset
[0x83]
2) Write Modulator and SYS_CLK Control Register (0x09) (13.56Mhz SYS_CLK and default Clock 13.56Mhz))
[0x09 0x31]
3) Configure Mode ISO Control Register (0x01) to 0x02 (ISO15693 high bit rate, one subcarrier, 1 out of 4)
[0x01 0x02]
4) Turn RF ON (Chip Status Control Register (0x00))
[0x40 r] [0x00 0x20] [0x40 r]
5) Inventory Command (see Figure 5-20. Inventory Command Sent From MCU to TRF7970A)
5-1) Send Inventory(8B), Wait 2ms, Read/Clear IRQ Status(0x0C=>0x6C)+dummy read,
Read FIFO Status Register(0x1C/0x5C), Read Continuous FIFO from 0x1F to 0x1F+0x0A(0x1F/0x7F),
Read/Clear IRQ Status(0x0C=>0x6C)+dummy read, Read FIFO Status Register(0x1C/0x5C),
Reset FIFO(0x0F/0x8F), Read RSSI levels and oscillator status(0x0F/0x4F)
[0x8F 0x91 0x3D 0x00 0x30 0x26 0x01 0x00] %:2 [0x6C r:2] [0x5C r] [0x7F r:10] %:10 [0x6C r:2] [0x5C r] [0x8F] [0x4F r]
==============================================================================*/






#include    "mbed.h"
#include    "readerComm.h"
uint8_t     sg=0;
DigitalOut  EN(p0);           // Control EN pin on TRF7970
DigitalOut  EN2(p4);        // Control EN2 pin on TRF7970
DigitalOut  CS(p9);
uint8_t    turnRFOn[2];
uint8_t    testcommand[2];
extern uint8_t noBytes;
extern  SPI             spi;                // main.cpp
extern  Serial          pc;                 // main.cpp
uint8_t         buf[300];           // main.cpp
uint8_t     found=0;
uint8_t rssi_flag=0;
uint8_t rssi=0;
extern DigitalOut BLED;
DigitalOut AO_7970(p29);
DigitalOut MOD_7970(p30);
int nfc=0;
//extern bool tagFound=0;

//extern  DigitalOut  debug1LED;
//extern  DigitalOut  debug2LED;
//extern  DigitalOut  ISO15693LED;
//extern  DigitalOut  heartbeatLED;
//extern  DigitalOut  testPin;
uint8_t     temp;
uint8_t     command[2];

uint8_t WAIT=0;
void trf797xDirectCommand(uint8_t *buffer)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xDirectCommand()
//  Description:    Transmit a Direct Command to the reader chip.
//  Parameter:      *buffer =   the direct command.
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    *buffer = (0x80 | *buffer);     // Setup command mode
    *buffer = (0x9F & *buffer);     // Setup command mode
    CS = SELECT;
    spi.write(*buffer);
    CS = DESELECT;
}   // End of trf797xDirectCommand()

void trf797xWriteSingle(uint8_t *buffer, uint8_t length)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xWriteSingle()
//  Description:    Writes to specified reader registers.
//  Parameters:     *buffer =   addresses of the registers followed by the
//                              contents to write.
//                  length =    number of registers * 2.
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    uint8_t i=0;

    CS = SELECT;
    while(length > 0) {
        *buffer = (0x1F & *buffer);     // Register address
        for(i = 0; i < 2; i++) {
            spi.write(*buffer);
            buffer++;
            length--;
        }
    }
    CS = DESELECT;

}   // End of trf797xWriteSingle()

void trf797xReadSingle(uint8_t *buffer, uint8_t number)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xReadSingle()
//  Description:    Reads specified reader chip registers and
//                  writes register contents to *buffer.
//  Parameters:     *buffer =   addresses of the registers.
//                  number  =   number of registers.
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    CS = SELECT;
    while(number > 0) {
        *buffer = (0x40 | *buffer);     // Address, read, single
        *buffer = (0x5F & *buffer);     // Register address
        spi.write(*buffer);
        *buffer = spi.write(0x00);      // *buffer <- register contents
        buffer++;
        number--;
    }
    CS = DESELECT;
}   // End of trf797xReadSingle()

void trf797xReadContinuous(uint8_t *buffer, uint8_t length)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xReadContinuous()
//  Description:    Used in SPI mode to read a specified number of
//                  reader chip registers from a specified address upwards.
//                  Contents of the registers are stored in *buffer.
//                  1) Read register(s)
//                  2) Write contents to *buffer
//  Parameters:     *buffer =   address of first register.
//                  length =    number of registers to read.
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    //==================tested wrk $sg
    CS = SELECT;
    *buffer = (0x60 | *buffer);     // Address, read, continuous
    *buffer = (0x7F & *buffer);     // Register address
    spi.write(*buffer);
    while(length > 0) {
        *buffer = spi.write(0x00);
        buffer++;
        length--;
    }
//    spi.write(0x00); spi.write(0x00);   // 16 clock cycles, see TRF7970A FW Design Hints SLOA159 section 7.3
    CS = DESELECT;

    //=====================tested it wrks $sg
}   // End of trf797xReadContinuous()

void trf797xRawWrite(uint8_t *buffer, uint8_t length)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xRawWrite()
//  Description:    Used in SPI mode to write direct to the reader chip.
//  Parameters:     *buffer =   raw data
//                  length =    number of data bytes
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    CS = SELECT;
    while(length > 0) {
        temp = spi.write(*buffer);
        buffer++;
        length--;
    }
    CS = DESELECT;
}   // End of trf797xRawWrite()

void trf797xStopDecoders(void)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xStopDecoders()
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    command[0] = STOP_DECODERS;
    trf797xDirectCommand(command);
}

void trf797xRunDecoders(void)
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//  trf797xRunDecoders()
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
{
    command[0] = RUN_DECODERS;
    trf797xDirectCommand(command);
}


void PowerUpNFC2(void)
{
    //CS = 1;
// wait_ms(4);
// EN = 1;
// EN2=1;

    CS = 0;
    EN2 = 0;
    EN = 0;
    wait_ms(2);
    CS = 1;
    wait_ms(3);
    EN2 = 1;
    wait_ms(1);
    EN = 1;
}
void PowerUpNFC(void)
{
    //CS = 1;
// wait_ms(4);
// EN = 1;
    EN2 = 1;
    wait_ms(1);
    EN=1;
}
void PowerDownNFC(void)
{
    ///CS=1;
    EN=0;
    EN2=0;
//wait_ms(1);
//EN2= 0;   PowerDown Mode
//EN2=1;    SleepMode
//CS=0;
}
void SleepNFC(void)
{
    EN=0;
    EN2=0;
}
void StandByNFC(void)
{
    turnRFOn[0] = CHIP_STATUS_CONTROL;
    turnRFOn[1] = CHIP_STATUS_CONTROL;

    turnRFOn[1] &= 0x3F;
    turnRFOn[1] |= 0x80;
    trf797xWriteSingle(turnRFOn, 2);
}

void SpiInit1(void)
{
    spi.format(8, 1);       // 8 bit data, mode = 1 (transition on rising edge, sample on falling edge)
    spi.frequency(250000);
}

void SpiInit(void)
{
    spi.format(8, 1);       // 8 bit data, mode = 1 (transition on rising edge, sample on falling edge)
    spi.frequency(1000000);
}

void NFCInit(void)
{
    //testPin=1;
//wait_ms(2);

    testcommand[0] = SOFT_INIT;
    trf797xDirectCommand(testcommand);
    wait_ms(2);
    testcommand[0] = IDLE;
    trf797xDirectCommand(testcommand);
    wait_ms(2);
//testcommand[0] =NFC_TARGET_LEVEL  ;
//testcommand[1] = 0x00;
//trf797xWriteSingle(testcommand, 2);
    testcommand[0] = MODULATOR_CONTROL;
    testcommand[1] = 0x81;                  // 6.78 MHz, OOK 100%
    trf797xWriteSingle(testcommand, 2);
//wait_ms(2);
    testcommand[0] = MODULATOR_CONTROL;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = REGULATOR_CONTROL ;
    testcommand[1] = 0x07;
    trf797xWriteSingle(testcommand, 2);
    turnRFOn[0] = CHIP_STATUS_CONTROL;
    turnRFOn[1] = CHIP_STATUS_CONTROL;
    turnRFOn[1] &= 0x3F;
    turnRFOn[1] |= 0x00;

// Oroiginal code has 0x20 !!!
    trf797xReadSingle(turnRFOn, 1);
    turnRFOn[0] = CHIP_STATUS_CONTROL;
    turnRFOn[1] = CHIP_STATUS_CONTROL;
    turnRFOn[1] &= 0x3F;
    turnRFOn[1] |= 0x00;
    trf797xWriteSingle(turnRFOn, 2);
//wait_ms(2);

    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = ISO_CONTROL;
    testcommand[1] = 0x02;                  // 6.78 MHz, OOK 100%
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = IRQ_MASK;
    testcommand[1] = 0x3F;
    trf797xWriteSingle(testcommand, 2);
//wait_ms(6);
//testPin=0;
}

void RegisterReInitNFC(void)
{
    //testcommand[0] =NFC_TARGET_LEVEL  ;
//testcommand[1] = 0x00;
//trf797xWriteSingle(testcommand, 2);
    testcommand[0] = TX_TIMER_EPC_HIGH;
    testcommand[1] = 0xC1;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = TX_TIMER_EPC_LOW ;
    testcommand[1] = 0xC1;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = TX_PULSE_LENGTH_CONTROL ;
    testcommand[1] = 0x00;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = RX_NO_RESPONSE_WAIT_TIME  ;
    testcommand[1] = 0x30;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] =  RX_WAIT_TIME ;
    testcommand[1] = 0x1F;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = MODULATOR_CONTROL ;
    testcommand[1] = 0x81;     //0x34 100%ook@13MHz
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = RX_SPECIAL_SETTINGS ;
    testcommand[1] = 0x40;
    trf797xWriteSingle(testcommand, 2);
    testcommand[0] = REGULATOR_CONTROL ;
    testcommand[1] = 0x07;
    trf797xWriteSingle(testcommand, 2);
}


void RegistersReadNFC(void)
{
    turnRFOn[0] = CHIP_STATUS_CONTROL;
    trf797xReadSingle(turnRFOn, 1);
    testcommand[0] = ISO_CONTROL;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = TX_TIMER_EPC_HIGH;          //0xC1;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = TX_TIMER_EPC_LOW ;          //0xC1;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = TX_PULSE_LENGTH_CONTROL ;   //0x00;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = RX_NO_RESPONSE_WAIT_TIME  ; //0x30;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] =  RX_WAIT_TIME ;             //0x1F;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = MODULATOR_CONTROL ;         //0x21;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = RX_SPECIAL_SETTINGS ;       //0x40;
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = REGULATOR_CONTROL ;        //0x87;
    trf797xReadSingle(testcommand, 1);
}

void InventoryReqNFC(void)
{
//send inventory command==================================================
    buf[0]=0x8F; //Send Inventory(8B)[0x8F 0x91 0x3D 0x00 0x30 0x26 0x01 0x00]
    buf[1]=0x91;
    buf[2]=0x3D;
    buf[3]=0x00;
    buf[4]=0x30;
    buf[5]=0x26;
    buf[6]=0x01;
    buf[7]=0x00;
    trf797xRawWrite(&buf[0],8);
//read rssi register and interchange rx input to main and aux receiver blocks
//{add code block here
//    }
    wait_ms(2);
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    wait_ms(5);
//testcommand[0] = CHECK_EXTERNAL_RF;
//trf797xDirectCommand(testcommand);
//wait_ms(1);
    testcommand[0] = RSSI_LEVELS;            //Read RSSI levels and oscillator status(0x0F/0x4F)
    trf797xReadSingle(testcommand, 1);
    printf("RSSI:%X \r\n", testcommand[0]);
    /*====================================read tag ID
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    testcommand[0] = FIFO_COUNTER;           //Read FIFO Status Register(0x1C/0x5C)
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = 0x7F & testcommand[0];   // Determine the number of bytes left in FIFO
    buf[0] = FIFO;
    trf797xReadContinuous(&buf[0], testcommand[0]);
    testcommand[0] = RSSI_LEVELS;            //Read RSSI levels and oscillator status(0x0F/0x4F)
    trf797xReadSingle(testcommand, 1);
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    testcommand[0] = RESET;                  //Reset FIFO(0x0F/0x8F)
    trf797xDirectCommand(testcommand);
    trf797xStopDecoders();
    trf797xRunDecoders();  */
//=====================================read Tag ID
//wait(1);
}

void FindNFC(uint8_t *irqStatus)
{
    //found=0;
//static uint8_t sg;
//printf("%X \r\n", *irqStatus);

    switch(*irqStatus) {
        case BIT0:
            found=BIT0;
            WAIT=10;
            break;
        case BIT1:
            found=BIT1;
            break;
            // case BIT2://found=BIT2; // break;
            //case BIT3:found=BIT3; WAIT=0;break;
//   case BIT4:found=BIT4; WAIT=0;break;
//   case BIT5:found=BIT5; WAIT=0;break;
        case 0x40:
            found=0x40;
            break;
        case BIT7:
            found=BIT7;
            break;
        default:
            found=0;
    }


}
void handlerNFC(void)
{
    testcommand[0] = IRQ_STATUS;
    trf797xReadSingle(testcommand,1);
    FindNFC(testcommand);
//wait_ms(1);
//=============================use if trf7970a irq_status is not cleared
//testcommand[0] = IRQ_STATUS;
//trf797xReadSingle(testcommand,1);
//=============================
}


void MemReadReqNFC(void)
{
    testcommand[0] = RX_NO_RESPONSE_WAIT_TIME  ;
    testcommand[1] = 0xFF;
    trf797xWriteSingle(testcommand, 2);
//send inventory command==================================================
    buf[0]=0x8F; //Send Inventory(8B)[0x8F 0x91 0x3D 0x00 0x30 0x26 0x01 0x00]
    buf[1]=0x91;
    buf[2]=0x3D;
    buf[3]=0x00;
    buf[4]=0x30;
    buf[5]=0x02;
    buf[6]=0x20;
    buf[7]=0x00;
    trf797xRawWrite(&buf[0],8);

//read rssi register and interchange rx input to main and aux receiver blocks
//{add code block here
//    }
//wait_ms(2);
//testPin=1;
//=========================use to clear irq_status register of trf7970a
//testcommand[0] = IRQ_STATUS;
//trf797xReadSingle(testcommand,1);
//testcommand[0] = IRQ_STATUS;
//trf797xReadSingle(testcommand,1);
//==========================
    wait_ms(5);
//testcommand[0] = CHECK_EXTERNAL_RF;
//trf797xDirectCommand(testcommand);
//wait_us(100);
    testcommand[0] = RSSI_LEVELS;
    //Read RSSI levels and oscillator status(0x0F/0x4F)
    trf797xReadSingle(testcommand, 1);
    rssi=testcommand[0];
    
    printf("RSSI:%X \r\n", testcommand[0]);
}
void ReadNFC(void)
{
    /*========================================== read irqstatus reg. of trf7970a
    //testcommand[0] = IRQ_STATUS;                clear irqstatus reg of trf7970a
    //trf797xReadSingle(testcommand,1);
    //testcommand[0] = IRQ_STATUS;
    //trf797xReadSingle(testcommand,1);
    ===========================================*/

    noBytes = FIFO_COUNTER;           //Read FIFO Status Register(0x1C/0x5C)
    trf797xReadSingle(&noBytes, 1);
    noBytes = 0x7F & noBytes;   // Determine the number of bytes left in FIFO
    buf[0] = FIFO;
    trf797xReadContinuous(&buf[0],noBytes);
//==use if trf7970a irq_status is not cleared
//testcommand[0] = IRQ_STATUS;
//trf797xReadSingle(testcommand,1);
//testcommand[0] = IRQ_STATUS;
//trf797xReadSingle(testcommand,1);
//=========================================
    testcommand[0] = RESET;                  //Reset FIFO(0x0F/0x8F)
    trf797xDirectCommand(testcommand);

//wait(1);
}









bool PollNFC(void)
{
    printf("PollNFC \r\n");
//CS=1;
  //  PowerUpNFC();
//////wait_ms(1);
   // NFCInit();
   // RegisterReInitNFC();
    MemReadReqNFC();
    printf("back from MemReadReqNFC \r\n");
    if (rssi>0x50)
    {rssi_flag=1;}
    else{rssi_flag=0;}
     nfc++;
//InventoryReqNFC();
    wait_ms(WAIT);

    switch(found) {
        case BIT0:
            printf("no response:");
            printf("%X \r\n",found);
            found=0;
            WAIT=0;
            break;
// //case BIT1:
// //case BIT2:
// //case BIT3:
//// case BIT4:
//// case BIT5:
        case BIT6:
            ReadNFC();
//PowerDownNFC();                       //SleepNFC() //StandByNFC()
            found=1;
            WAIT=0;
            break;
        case BIT7:
            printf("tx complete:");
            printf("%X \r\n",found);
            found=0;
            WAIT=0;
            break;
        default:
            if((nfc>10)&&(rssi_flag=1));
            {rssi_flag=0;
             nfc=0;
                PowerUpNFC();
                NFCInit();
                RegisterReInitNFC();
                printf("resetting 7970 \r\n:");
                found=0;
            }
    }

    return found;

}