/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Filename:       main.cpp
    Description:    Interface nRF51-DK eval board to TRF7970 eval board
                    to test the suitability of the TRF7970 NFC chip
                    for use in Gymtrack products.
                    The nRF51-DK board has an nRF51422 MCU.
    Copyright (C)   2015 Gymtrack, Inc.
    Author:         Ron Clough
    Date:           2015-02-26

    Changes:
    Rev     Date        Who     Details
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    0.0     2015-02-26  RWC     Original version.

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include    "mbed.h"

//#include    "NFC_7970.h"
#include    "readerComm.h"
#include "BLEDevice.h"
#include "HeartRateService.h"
#include "DeviceInformationService.h"
#include "GT_Timer.h"
#include "CompareTime.h"
SPI         spi(p7, p8, p3); // MOSI, MISO, SCLK
// Slave Select (SS)
#define BLED_PIN p17
#define RLED_PIN p19
#define GLED_PIN p18
DigitalOut BLED(BLED_PIN);
DigitalOut RLED(RLED_PIN);
DigitalOut GLED(GLED_PIN);

Serial      pc(p24, p25);   // Serial communication over USB with PC
//DigitalOut  heartbeatLED(LED4); // "Heartbeat" LED
//DigitalOut  debug2LED(LED2);    // "Debug2" LED
//DigitalOut  ISO15693LED(LED3);  // "Detected ISO15693 tag" LED
//DigitalOut  debug1LED(LED1);    // "Debug1" LED
extern DigitalOut  EN;           // Control EN pin on TRF7970
extern DigitalOut  EN2;        // Control EN2 pin on TRF7970
extern DigitalOut  CS;
extern DigitalOut AO_7970;
extern DigitalOut MOD_7970;
//DigitalInOut  ook_ask(p6);      // Control ASK/OOK pin on TRF7970
//DigitalOut  mod(p5);            // Control MOD pin on TRF7970
InterruptIn     readerInt(p28);
//DigitalOut  testPin(p1);
BLEDevice  ble;
extern uint8_t     buf[300];
uint8_t noBytes=0;
extern uint8_t    turnRFOn[2];
extern uint8_t    testcommand[2];
extern uint8_t     found;
extern int nfc;
bool tagFound=0;
//uint8_t     WAIT=0;
int next_reading_tag=0;
int main()
{
    //testPin=0;
    pc.baud(115200);
    AO_7970= 0;
    MOD_7970=0;
//=============================================================ble test
// ble.init();
//// ble.onDisconnection(disconnectionCallback);
// //
////    /* Setup advertising. */
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
////  //  ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_HEART_RATE_SENSOR);
////   // ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
//    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
//    ble.setAdvertisingInterval(1000);
//    ble.startAdvertising();
//===============================================================*/

    readerInt.rise(&handlerNFC);
    CS=1;
    SpiInit(); //spi=1Mhz
    PowerUpNFC();
    NFCInit();
    RegisterReInitNFC();
    RegistersReadNFC();
//PowerDownNFC();                      //SleepNFC() //StandByNFC()
//SleepNFC();
    BLED=0;
    /** Print the text
            *
            * @groups PollNFC
            *
            *   1 on success,
            *   0 on serial error
            */

    while(1) {
      //  PowerUpNFC();
     // NFCInit();
//        RegisterReInitNFC();
        

        while(tagFound==0) {
          //  printf("tag nt found \r\n");
            //BLED=1;
//testcommand[0] = 0x17;
//trf797xDirectCommand(testcommand);
//testcommand[0] = 0x18;
//trf797xDirectCommand(testcommand);
//wait_ms(5);
//testcommand[0] = RSSI_LEVELS;            //Read RSSI levels and oscillator status(0x0F/0x4F)
//trf797xReadSingle(testcommand, 1);
//printf("RSSI:%X \r\n", testcommand[0]);
//tagFound=PollNFC();

            tagFound=PollNFC();
           // RegisterReInitNFC();
//wait_ms(5);
            //int tag= CompareTime( gt_read_ms(),next_reading_tag,50);
//
//            if (tag<0) {
//                ;
//            } else {
//                    RLED=1;
//                    wait_ms(5);
//                    RLED=0;
//                next_reading_tag = gt_read_ms();
             //   printf("time out : no tag \r\n");
//                break;
//
//            }
        }
//
        if(tagFound==1) {nfc=0;
            //printf("read single block:");
            BLED=1;
            for(uint8_t i=0; i<noBytes; i++)
                printf("%X ", buf[i]);
            printf("\r\n");
            printf("tag found \r\n");
            BLED=0;
            tagFound=0;
//////
//////// //break;
        } //else {
//            printf("tag nt found \r\n");
//        }
//////

        
       PowerDownNFC();
     //   wait(2);
    }

}


