
//#define EN_7970_PIN p0
//#define DETECT_METAL_PIN p1
//#define METAL_THRESH_PIN p2
//#define SPI_CLK_PIN p3
//#define EN2_7970_PIN p4
//#define VUSBMON_PIN p5
//#define VBATMON_PIN p6
//#define SPI_MOSI_PIN p7
//#define SPI_MISO_PIN p8
//#define CS_7970_PIN p9
//#define TP1_PIN p10 //use this one for the serial port TX
//#define WD_CONTROL_PIN p11
//#define WATCHDOG_PIN p12
//#define CHARGING_PIN p13
//#define SCL_PIN p14
//#define SDA_PIN p15
//#define ADXL345_INT_PIN p16
//#define BLED_PIN p17
//#define GLED_PIN p18
//#define RLED_PIN p19
//#define UNUSED_20_PIN p20
//#define DETECT_METAL_INT_PIN p21
//#define COILPWR_PIN p22
//#define UNUSED_23_PIN p23
//#define TP4_PIN p24
//#define TP5_PIN p25
//#define IRQ_7970_PIN p28
//#define AO_7970_PIN p29
//#define MOD_7970_PIN p30

//  Prototypes
//void SpiInit1(void);                                               // SPI 250 Khz
void SpiInit(void);                                                  // SPI 1Mhz
void trf797xDirectCommand(uint8_t *buffer);                          // send direct command to trf7970a
void trf797xWriteSingle(uint8_t *buffer, uint8_t length);            // write to trf7970a register
void trf797xReadSingle(uint8_t *buffer, uint8_t number);             // read trf7970a register  
void trf797xReadContinuous(uint8_t *buffer, uint8_t length);         // read continuous bytes from trf7970a
void trf797xRawWrite(uint8_t *buffer, uint8_t length);               // raw write to trf7970a FIFO
void PowerUpNFC(void);                                               // powerup trf7970a 
void PowerUpNFC2(void);
void PowerDownNFC(void);                                             // powerdown trf7970a 
void NFCInit(void);                                                  // initialize trf7970 iso control =0x02, chip status control=0x20, modulator=0x21
void RegisterReInitNFC(void);                                        // reinitialize nfc status registers
void RegistersReadNFC(void);                                         // read nfc status registers
void InventoryReqNFC(void);                                          // inventory request to trf7970a
void MemReadReqNFC(void);                                            // memory read request to trf7970a
void ReadNFC(void);                                                  // read teag ID/Single Read
void FindNFC(uint8_t *irqStatus);                                    // read irq from trf7970a.          
void handlerNFC(void);                                               // trf7970 irq handler    
void StandByNFC(void);
void SleepNFC(void);
bool PollNFC(void); 
//uint8_t pwr_mode ;

        
//  Booleans 
#define     DESELECT        1
#define     SELECT          0
#define     ADDRESS         0
#define     COMMAND         1
#define     WRITE           0
#define     READ            1
   
//led
#define     LED_ON      0
#define     LED_OFF     1
#define     FALSE       0
#define     TRUE        1

//  Direct commands for trf797x
#define IDLE                        0x00
#define SOFT_INIT                   0x03
#define INITIAL_RF_COLLISION        0x04
#define RESPONSE_RF_COLLISION_N     0x05
#define RESPONSE_RF_COLLISION_0     0x06
#define RESET                       0x0F
#define TRANSMIT_NO_CRC             0x10
#define TRANSMIT_CRC                0x11
#define DELAY_TRANSMIT_NO_CRC       0x12
#define DELAY_TRANSMIT_CRC          0x13
#define TRANSMIT_NEXT_SLOT          0x14
#define CLOSE_SLOT_SEQUENCE         0x15
#define STOP_DECODERS               0x16
#define RUN_DECODERS                0x17
#define CHECK_INTERNAL_RF           0x18
#define CHECK_EXTERNAL_RF           0x19
#define ADJUST_GAIN                 0x1A

//  Registers for trf797x
#define CHIP_STATUS_CONTROL         0x00
#define ISO_CONTROL                 0x01
#define ISO_14443B_OPTIONS          0x02
#define ISO_14443A_OPTIONS          0x03
#define TX_TIMER_EPC_HIGH           0x04
#define TX_TIMER_EPC_LOW            0x05
#define TX_PULSE_LENGTH_CONTROL     0x06
#define RX_NO_RESPONSE_WAIT_TIME    0x07
#define RX_WAIT_TIME                0x08
#define MODULATOR_CONTROL           0x09
#define RX_SPECIAL_SETTINGS         0x0A
#define REGULATOR_CONTROL           0x0B
#define IRQ_STATUS                  0x0C
#define IRQ_MASK                    0x0D
#define COLLISION_POSITION          0x0E
#define RSSI_LEVELS                 0x0F
#define SPECIAL_FUNCTION_1          0x10
#define SPECIAL_FUNCTION_2          0x11
#define RAM_0                       0x12
#define RAM_1                       0x13
#define FIFO_IRQ_LEVELS_ADJ         0x14
#define RESERVED                    0x15
#define NFC_LOW_DETECTION           0x16
#define NFCID                       0x17
#define NFC_TARGET_LEVEL            0x18
#define NFC_TARGET_PROTOCOL         0x19
#define TEST_SETTINGS_1             0x1A
#define TEST_SETTINGS_2             0x1B
#define FIFO_COUNTER                0x1C
#define TX_LENGTH_BYTE_1            0x1D
#define TX_LENGTH_BYTE_2            0x1E
#define FIFO                        0x1F

//  BITs
#define BIT0                        0x01    // 0b00000001
#define BIT1                        0x02    // 0b00000010
#define BIT2                        0x40    // 0b00000100
#define BIT3                        0x08    // 0b00001000
#define BIT4                        0x10    // 0b00010000
#define BIT5                        0x20    // 0b00100000
#define BIT6                        0x40    // 0b01000000
#define BIT7                        0x80    // 0b10000000

//  Misc
#define SIXTEEN_SLOTS               0x06
#define ONE_SLOT                    0x26

