#include "mbed.h"

// Globale objekter og variable
Serial pc(USBTX, USBRX);
int numbers[100]; // Tabell som skal fylles med tallverdier

// Funksjonsprototyper for funksjonene som skal skrives
int get_seed();
int get_number_of_elements();
int mySeed, numElements;
void fill_array(int seed, int arr[], int len);
void sort_array(int arr[], int len);
void print_array(int arr[], int len);

int main()
{
    mySeed = get_seed();
    numElements = get_number_of_elements();
    fill_array(mySeed, numbers, numElements );
    print_array(numbers, numElements );
    sort_array(numbers, numElements );
    print_array(numbers, numElements );

    return 0;
}
int get_seed()
{
    int tall;
    pc.printf("Tast inn et tall:");
    pc.scanf("%d",&tall);
    pc.printf("%d\n",tall);
    return  tall;
}
int get_number_of_elements()
{
    int elementer;
    pc.printf("Tast inn hvor mange elementer du vil ha i tabellen:");
    pc.scanf("%d",&elementer);
    pc.printf("%d\n",elementer);
    return  elementer;
}
void fill_array(int seed, int arr[], int len)
{
    int rnd;
    srand(seed);
    for (int i = 0; i < len; i++) {
        rnd = (rand() % 101);
        arr [i] = rnd;
    }
}
void sort_array(int arr[], int len)
{
    int unsorted = 1;// Starter med å anta at tabellen er usortert
    while(unsorted) {
        unsorted = 0;  // Antar så at dette er siste gjennomløp

        for(int a = 0; a < len-1; a++) {
            if (arr[a] > arr[a+1]) { // Hvis feil rekkefølge:
                // bytt plass.
                float x;                   // x er en hjelpevariabel
                x = arr[a];
                arr[a] = arr[a+1];
                arr[a+1] = x;
                unsorted = 1; // Minst ett bytte gjør at
                // tabellen må testes på nytt
            }
        }
    }

}
void print_array(int arr[], int len)
{
    int lf = 0;
    for (int i = 0; i < len; i++) {
        lf = 0;
        pc.printf("%6d", arr[i]);
        if((i % 3) == 2) {
            printf("\n");
            lf = 1;
        }
    }
    if (lf == 0) {
        printf("\n");
    }
}











