#include "mbed.h"

// Definisjoner for lett å kunne operere på lysene
#define RED    4
#define YELLOW 2
#define GREEN  1
#define ON     1
#define OFF    0

// Vi simulerer en systemklokke på 10 Hz:
// Sekundverdiene må derfor skaleres med en faktor på 10
#define _10SEK  100
#define _5SEK   50
#define _4SEK   40
#define _2SEK   20
#define _1SEK   10

// GLOBAL OBJECTS
Ticker tc;                       // Simulates the 10 Hz clock
DigitalOut FK(LED1);             // PEDgjenger KLAR
DigitalOut FV(LED4);             // PEDgjenger VENT
BusOut ns_lights(p21, p22, p23); // Traffic light (G1, Y1, R1)
BusOut ew_lights(p26, p27, p28); // Traffic light (G2, Y3, R3)
DigitalIn PED(p12);              // Pedstrian control

// GLOBAL VARIABLES
volatile int sysclock = 0;  // Variable indicates clock value
int time_tick = 0;          // Global variable to implement time delay
volatile int button = 0;

// DEFINITION OF STATES AND STATE VARIABLE
enum {OV0, OV1, OV2, OV3, NS0, NS1, NS2, NS3,PED1, PED2, ILLEGAL} state;
void day_night_control(void); // function prototype for day_night_control
void tick_control(void);      // function prototype for tick_control
void fsm(void);                   // selve tilstandsmaskinen

// Et enkelt hovedprogram
int main(void)
{
    // start tick_control each 0.05 sec. --> 10 Hz clock
    tc.attach(&tick_control, 0.05);
    state = OV0;
    time_tick = 0;
    
    while(1) {
        fsm();
        while (sysclock == 1);
        while (sysclock == 0);
        time_tick++;
    }
}
// The purpose of this ticker is to simulate a 10 Hz clock in the system
// Called each 0.05 sek - two calls per clock tick
void tick_control()
{
    // Duty cycle for the clock variable is 50 %
    sysclock = !sysclock;
}
void fsm(void)
{
    static int button = 0;
    switch (state) {
        case OV0:
            ns_lights = RED;
            ew_lights = GREEN;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if (time_tick >= _10SEK) {
                time_tick = 0;
                state = OV1;
            }
            break;
        case OV1:
            ns_lights = RED;
            ew_lights = YELLOW;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if (time_tick >= _2SEK) {
                time_tick = 0;
                state = OV2;
            }
            break;
        case OV2:
            ns_lights = RED;
            ew_lights = RED;
            FK = OFF;
            FV = ON;
            if (PED == ON || button == 1) {
                time_tick = 0;
                state = PED1;
                button = 0;
            }
            if (time_tick >= _1SEK) {
                time_tick = 0;
                state = OV3;
            }
            break;
        case OV3:
            ns_lights = RED+YELLOW;
            ew_lights = RED;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if(time_tick >= _1SEK) {
                time_tick = 0;
                state = NS0;
            }
            break;
        case NS0:
            ns_lights = GREEN;
            ew_lights = RED;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if(time_tick >= _5SEK) {
                time_tick = 0;
                state = NS1;
            }
            break;
        case NS1:
            ns_lights = YELLOW;
            ew_lights = RED;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if(time_tick >= _2SEK) {
                time_tick = 0;
                state = NS2;
            }
            break;
        case NS2:
            ns_lights = RED;
            ew_lights = RED;
            FK = OFF;
            FV = ON;
            if (PED == ON || button == 1) {
                time_tick = 0;
                state = PED2;
                button = 0;
            }
            if(time_tick >= _1SEK) {
                time_tick = 0;
                state = NS3;
            }
            break;
        case NS3:
            ns_lights = RED;
            ew_lights = RED+YELLOW;
            FK = OFF;
            FV = ON;
            if (PED == ON) {
                button = 1;
            }
            if(time_tick >= _1SEK) {
                time_tick = 0;
                state = OV0;
            }
            break;
        case PED1:
            ns_lights = RED;
            ew_lights = RED;
            FK = ON;
            FV = OFF;
            if(time_tick >= _10SEK) {
                time_tick = 0;
                state = OV3;
            }
            break;
        case PED2:
            ns_lights = RED;
            ew_lights = RED;
            FV = OFF;
            FK = ON;
            if(time_tick >= _10SEK) {
                time_tick = 0;
                state = NS3;
            }
            break;
    }
}