#include "Pixy.h"


Pixy::Pixy(PinName mosi_sda_tx, PinName miso_scl_rx)
{
    m_link = new PixyLinkI2C(mosi_sda_tx, miso_scl_rx);
    pc = 0;
    skipStart = false;
    blockCount = 0;
    blockArraySize = PIXY_INITIAL_ARRAYSIZE;
    blocks = new Block[blockArraySize];

}

Pixy::~Pixy()
{
    delete[] blocks;
    delete m_link;
}

uint16_t Pixy::getBlocks(uint16_t maxBlocks)
{
    uint8_t i;
    uint16_t w, checksum, sum;
    Block *block;

    if (!skipStart) {
        if (getStart() == false)
            return 0;
    } else
        skipStart = false;

    for (blockCount = 0; blockCount < maxBlocks && blockCount < PIXY_MAXIMUM_ARRAYSIZE;) {
        checksum = m_link->getWord();
        if (checksum == PIXY_START_WORD) { // we've reached the beginning of the next frame
            skipStart = true;
        //  if (pc)
        //  pc->printf("skip\n\r");
            return blockCount;
        } else if (checksum == 0)
            return blockCount; // Made by Renske

        if (blockCount > blockArraySize)
            resize();

        block = blocks + blockCount;

        for (i = 0, sum = 0; i < sizeof(Block) / sizeof(uint16_t); i++) {
            w = m_link->getWord();
            sum += w;
            *((uint16_t *)block + i) = w;
        }

        if (checksum == sum){
            blockCount++;
            //w = m_link->getWord();
            }
        else if (pc)
            pc->printf("cs error\n\r");

        w = m_link->getWord();
        if (w != PIXY_START_WORD)
            return blockCount;
    }
    return blockCount;
}

void Pixy::setAddress(uint8_t addr)
{
    m_link->setAddress(addr);
}

void Pixy::setSerialOutput(Serial *pc)
{
    this->pc = pc;
}

bool Pixy::getStart()
{
    uint16_t w, lastw;

    lastw = 0xffff;
    while (true) {
        w = m_link->getWord();
        if (w == 0 && lastw == 0) {
            wait_ms(10);
            return false;
        } else if (w == PIXY_START_WORD && lastw == PIXY_START_WORD)
            return true;
        else if (w == PIXY_START_WORDX) {
            if (pc)
                pc->printf("reorder\n\r");
            m_link->getByte(); // resync
        }
        lastw = w;
    }
}

void Pixy::resize()
{
    Block *newBlocks;
    blockArraySize += PIXY_INITIAL_ARRAYSIZE;
    newBlocks = new Block[blockArraySize];
    memcpy(newBlocks, blocks, sizeof(Block) * blockCount);
    delete[] blocks;
    blocks = newBlocks;
}