#ifndef ROBOTER_H
#define ROBOTER_H

#include <mbed.h>
#include "IRSensor.h"
#include "Servo.h"
#include "readCamera.h"
#include "EncoderCounter.h"
#include "LowpassFilter.h"


class Roboter
{

public:

    Roboter(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, PwmOut* pwmL, PwmOut* pwmR, Servo* servo1, Servo* servo2, EncoderCounter* counterLeft, EncoderCounter* counterRight, DigitalOut* enableMotorDriver);

    void bandeAusweichen();
    float readSensor1();
    int pickup();
    void anfahren(float cam);
    int geradeFahren();
    int kreisFahren();
    int stateAuswahl(float cam, int temp);
    void initSpeedcontrol();
    void speedCtrl();



    static const float PERIOD = 0.001f;                    // period of control task, given in [s]
    static const float COUNTS_PER_TURN = 1200.0f;          // resolution of encoder counter
    static const float LOWPASS_FILTER_FREQUENCY = 300.0f;  // frequency of lowpass filter for actual speed values, given in [rad/s]
    static const float KN = 40.0f;                         // speed constant of motor, given in [rpm/V]
    static const float KP = 0.2f;                          // speed controller gain, given in [V/rpm]
    static const float MAX_VOLTAGE = 12.0f;                // supply voltage for power stage in [V]
    static const float MIN_DUTY_CYCLE = 0.02f;             // minimum allowed value for duty cycle (2%)
    static const float MAX_DUTY_CYCLE = 0.98f;             // maximum allowed value for duty cycle (98%)
    static const float correction = 0.97f;                 // Korrekturfaktor für speedControl
    static const float v = 20.0f;                          // Min. Geschw.

    
private:

    IRSensor sensors[6];

    PwmOut* pwmL;
    PwmOut* pwmR;
    Servo* servo1;
    Servo* servo2;

//speed control------------------

    EncoderCounter* counterRight;
    EncoderCounter* counterLeft;
    DigitalOut* enableMotorDriver;

    short previousValueCounterRight;
    short previousValueCounterLeft;

    float desiredSpeedLeft;
    float desiredSpeedRight;

    float actualSpeedLeft;
    float actualSpeedRight;

    LowpassFilter speedLeftFilter;
    LowpassFilter speedRightFilter;

    Ticker t1;

//speed control------------------

};

#endif