#include <mbed.h>
#include "Roboter.h"


//Periphery for Encoder
EncoderCounter counterLeft(PB_6, PB_7);
EncoderCounter counterRight(PA_6, PC_7);


//Periphery for distance sensors
AnalogIn distance(PB_1);
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);
IRSensor sensors[6];

// Periphery for servos
Servo servo1(PB_13);    //Greiferservo Anschluss D2
Servo servo2(PA_10);    //Armservo Anschluss D0

//Periphery for Switch ON/OFF
DigitalIn switchOnOff(USER_BUTTON);

//motor stuff
DigitalOut enableMotorDriver(PB_2);
PwmOut pwmL( PA_8 );
PwmOut pwmR( PA_9 );

//indicator leds arround robot
DigitalOut leds[] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };

// Erstellen eines Roboterobjekts
Roboter roboter1(&distance, &bit0, &bit1, &bit2, &pwmL, &pwmR, &servo1, &servo2, &counterLeft, &counterRight, &enableMotorDriver);

int main()
{
    int state = 0;         // Diese Variable gibt an in welchem State man sich befindet
    int tempState = 2;     // Wird benötig um zwischen Kameraauswertung und fahren zu wechseln
    int temp = 0;
    enable = 1;            // Sensoren einschalten
    servo1.Enable(1500,20000);
    servo2.Enable(700,20000);
    wait(1);
    float camValue;

    while(1) {

        //printf("%d\n", state);

        switch(state) {

            case 0: // Roboter Anschalten mit Knopf
                printf("0");

                if (switchOnOff == 0) { // Bei Betätigung des Userbuttons wird das Programm gestartet
                    state = 1;
                }

                break;

            case 1:
                //printf("1");
                camValue = readCamera(state);
                state = roboter1.stateAuswahl(camValue, tempState, temp); // Case-Auswahl aufgrund von der Kamera
                break;

            case 2:
                //printf("2");
                tempState = 2;
                temp = 0;
                state = roboter1.kreisFahren(); // Im Kreis fahren
                break;


            case 3:
                //printf("3");
                tempState = 3;
                temp = 0;
                roboter1.ausweichen1();  // Hindernissen ausweichen
                state = roboter1.geradeFahren(); // Gerade Fahren
                break;


            case 4:
                //printf("4");
                tempState = 2;
                temp = 0;
                roboter1.anfahren(camValue); // Roboter erkennt grünen Klotz, Klotz wird angefahren
                state = roboter1.readSensors();
                break;

            case 5:
                //printf("5");
                state = roboter1.pickup(); // Aufnehmen des Klotzes
                temp = 5;
                break;

            case 6:
                //printf("6");
                temp =0;
                state = roboter1.ausweichen2();  // Hindernissen ausweichen während Klotz angefahren wird
                break;

            case 7:
                //printf("7");
                temp = 0;
                state = roboter1.back();
                break;

            default:
                break;

        }
        //printf("%d\n", state);
        wait(0.001f);
    }
}
