#include <cmath>
#include "IRSensor.h"


/**
 * Creates an IRSensor object.
 * @param distance an analog input object to read the voltage of the sensor.
 * @param bit0 a digital output to set the first bit of the multiplexer.
 * @param bit1 a digital output to set the second bit of the multiplexer.
 * @param bit2 a digital output to set the third bit of the multiplexer.
 * @param number the number of the sensor, either 0, 1, 2, 3, 4 or 5.
 */
IRSensor::IRSensor(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{
    init(distance, bit0, bit1, bit2, number);
}


IRSensor::IRSensor()
{
}

void IRSensor::init(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{

    this->distance = distance;  // set local references to objects
    this->bit0 = bit0;
    this->bit1 = bit1;
    this->bit2 = bit2;

    this->number = number;
}


/**
 * Deletes the IRSensor object.
 */
IRSensor::~IRSensor() {}

/**
 * Gets the distance measured with the IR sensor in [m].
 * @return the distance, given in [m].
 */
float IRSensor::read()
{
    *bit0 = (number >> 0) & 1;
    *bit1 = (number >> 1) & 1;
    *bit2 = (number >> 2) & 1;

    float d = -0.38f*sqrt(distance->read())+0.38f;  // calculate the distance in [m]
    return d;
}

/**
 * The empty operator is a shorthand notation of the <code>read()</code> method.
 */
IRSensor::operator float()
{

    return read();
}
