#define tx PC_10
#define rx PC_11

Serial WiFi(D8, D2); // tx, rx
Serial Mach(tx, rx);
Timer t;

string file_name;
vector <string> filenames;

class Machine { 
    int n;
    string buffer;
    char buffer_char[2];
    
    public:
        int debug;
    
        // PUBLIC FUNCTIONS ----------------------------------------------------------------------------------------------------------------------------------------     
        void move(string move_code){
            printf("Moving: %s\n\r",  move_code);
            send(move_code);
        } 
        
        void save_point(int mode, float pct_speed){
            buffer = "";
            
            buffer.append("s");
            
            n = sprintf(buffer_char, "M%d", mode);
            buffer.append(buffer_char);
            
            n = sprintf(buffer_char, "F%.2f", pct_speed);
            buffer.append(buffer_char);
            
            send(buffer);
        }
        
        void start_program(void){
            send("b");  
            printf("Starting Program\n\r");  
        }
        
        void cancel_program(void){
            send("c");    
        }
        
        void get_status(void){
            send("s");
        }
        
        void machine_zero(void){
            send("zm");
            printf("Zero Machine\n\r");
        }
        
        void set_zero(string axis){
            buffer = "";            
            buffer.append("z");
            buffer+=axis;
            send(buffer);    
        }
        
        void jog(void){
            send("j");
            printf("Starting Jog\n\r"); 
        }
        
        void kill_jog(void){
            send("jk");
            printf("Killing Jog\n\r"); 
        }
        
        void reset(void){
            send("r");
        }
        
        void upload_gcode(string gcode){
            buffer = "";
            buffer.append("u");
            buffer.append(gcode);
            
            printf("Uploading GCODE: %s\n\r", gcode);
            
            send(buffer);
        }
        
        void get_saved_points(void){
            send("l");    
        }
        
        void delete_last_saved(void){
            send("d");    
        }
        
        void clean_glue(void){
            send("g");   
            printf("Cleaning Glue\n\r");     
        }
        
        private:
            
            // PRIVATE FUNCTIONS ----------------------------------------------------------------------------------------------------------------------------------------
            void send(string msg){
                msg.append("x");
                
                for(int i = 0; i < msg.length(); i++){
                    Mach.putc(msg[i]);
                    wait_ms(20);   
                }
            }       
};


Machine machine;

SDFileSystem sd(PB_15, PB_14, PB_13, PB_1, "sd"); //MOSI - D4, MISO - D5, SCLK - D3, CS - D7
DIR *dp;

string folderString = "Programas";

class SDCard{
    public:        
        int save_GCODE(string name, string gcode){
            printf("Saving: %s\n\r", name);
            //printf("Code: %s\n\r", gcode);
            
            string file_path = "/sd/" + folderString + "/" + name; 
            char * path = str_to_char(file_path);
            
            printf(path);
            
            //printf("going...\n\r");
            
            FILE *fp = fopen(path, "w");
            
            if(fp == NULL) {
                error("Could not open file for write\n\r");
                return 0;
            }
            
            char * write_file = str_to_char(gcode);
            
            fprintf(fp, write_file);
            fclose(fp);
            
            printf("Saving done!\n\r");
            
            return 1;
        }
        
        int send_gcode(string name){
            printf("Sending gcode...\n\r");            
            string file_path = "/sd/" + folderString + "/" + name; 
            char * path = str_to_char(file_path);
            unsigned char c;
            string buffer;
            
            FILE *fp = fopen(path, "r");
            
            if(fp == NULL) {
                error("Could not open file for write\n\r");
                return 0;
            }  
            t.reset();
            t.start();
            
            while(1){
                if(t.read() > 4.0){
                    fclose(fp);
                    return 0;    
                }
                c = fgetc(fp);
                buffer.push_back(c);
                printf("%c\n\r", c);
                if(c == ';'){
                    fclose(fp);
                    break;    
                }
            }
            fclose(fp);
            
            machine.upload_gcode(buffer);
            return 1;
        }
        
        int check_name_available(string name){
            printf("Checking name...\r\n");
            string file_path = "/sd/" + folderString;
            char * dir = str_to_char(file_path);
            struct dirent *dirp;
            string filename;
            
            //printf(dir);
            
            dp = opendir(dir);
            
            t.reset();
            t.start();
            
            while((dirp = readdir(dp)) != NULL) {
                if(t.read() > 2.0){
                    t.stop();
                    closedir(dp);
                    printf("Timeout\r\n");
                    return 0;    
                }
                filename = (dirp->d_name);
                //printf("%s\n\r", filename);
                if(filename == name){
                    closedir(dp);
                    return 0;  
                }                  
            } 
            closedir(dp);
            printf("Checked!\n\r");
            return 1; 
        }
        
        int get_file_names(void){
            string file_path = "/sd/" + folderString;
            char * dir = str_to_char(file_path);
            struct dirent *dirp;
            string filename;
            
            filenames.empty();
            
            //printf(dir);
            
            dp = opendir(dir);
        
            while((dirp = readdir(dp)) != NULL) {
                filename = (dirp->d_name);
                //printf("%s\n\r", filename);
                filenames.push_back(filename);                 
            } 
            //printf("%d\n\r", filenames.size());
            return 1; 
        }
        
        int create_folders(void){
            int gotFolder = 0;
            string filename;
            struct dirent *dirp;
            
            dp = opendir("/sd");
            
            t.start();
        
            while((dirp = readdir(dp)) != NULL) {
                if(t.read() > 2){
                    t.stop();
                    return 0;    
                }
                filename = (dirp->d_name);
                //printf("%s\n\r", filename);
                if(filename == folderString){
                    gotFolder = 1;
                }   
            }
            
            if(!gotFolder){
                char * path = str_to_char(("/sd/" + folderString));
                mkdir(path, 0777);
            }
            
            closedir(dp);
            return 1;
        }    
        
        private:
            char * str_to_char(string str){
                char * path = new char[str.length() + 1];
                std::strcpy(path, str.c_str());
                return path;
            } 
};

SDCard sdcard;

//criar classe "menu" (funções para as telas)
class Menu{
    
    public:
    int linha;
    int func;
    string nome;
    string arquivo;
   
    
    void movercursor(int min, int max, int col){ //função para mover cursor de seleção
        linha = min;
        lcd.locate(col,min);
        lcd.printf("%c", 0x3E);
        while (bot_enter==penter){
            if(emerg){
                func = 31;
                break;
            }
            if(func == 13){
                if(clean_wifi.read()>6.0){
                    lcd.locate(0,1);
                    lcd.printf("                    ");    
                }
                if(WiFi.readable()){
                    wifiRx();    
                }    
            }
            if (bot_cima==0){
                if (linha==min){
                    lcd.locate(col,min);
                    lcd.printf(" ");
                    linha=max;
                    lcd.locate(col, linha);
                    lcd.printf("%c", 0x3E);
                    } 
                else {
                    lcd.locate(col,linha);
                    lcd.printf(" ");
                    linha--;
                    lcd.locate(col, linha);
                    lcd.printf("%c", 0x3E);
                    }  
                bot_cima = 1;
                }
            else if (bot_baixo==0){
                if (linha==max){
                    lcd.locate(col,max);
                    lcd.printf(" ");
                    linha=min;
                    lcd.locate(col, linha);
                    lcd.printf("%c", 0x3E);
                    }
                else {
                    lcd.locate(col,linha);
                    lcd.printf(" ");
                    linha++;
                    lcd.locate(col, linha);
                    lcd.printf("%c", 0x3E);
                    }
                bot_baixo = 1;
                }
            }                    
        }
        
                       
    //func 0
    void inicializar(){ //função tela incial de boas-vindas
        bot_enter = penter;
        //int status;        
        printf("Starting...\n\r");        
        machine.reset();
        lcd.cls();
        lcd.locate(4,0);
        lcd.printf("Bem-vindo(a)");
        lcd.locate(0,1);
        lcd.printf("Utilize seu EPI para operar a maquina.");
        lcd.locate(9,3);
        lcd.printf("OK");
        movercursor(3,3,8);
        if (bot_enter!=penter){
            if (linha==3){
                func = 1;
                }
            }
        }
    
    //func 1    
    void menuprincipal(){ //função menu principal
        machine.kill_jog();
        bot_enter = penter;
        sair = 0;
        lcd.cls();
        lcd.locate(1,0);
        lcd.printf("Modo JOG");
        lcd.locate(1,1);
        lcd.printf("Modo Automatico");
        lcd.locate(1,2);
        lcd.printf("Zerar");
        lcd.locate(1,3);
        lcd.printf("Menu");
        movercursor(0,3,0);
        if (bot_enter!=penter){
            if (linha==0){
                func = 2;
                }
            else if (linha==1) {
                func = 3;
                }
            else if (linha==2) {
                func = 8;
                }
            else if (linha==3) {
                func = 4;
                }
            }
        } 
        
    //func 2    
    void jog(){ //função tela jog
        
        lcd.cls();
        bot_enter = penter;
        machine.kill_jog();
        wait(0.1);
        machine.jog();
        lcd.locate(2,1);
        lcd.printf("MODO");
        lcd.locate(2,2);
        lcd.printf("JOG");
        lcd.locate(11,0);
        lcd.printf("Salvar");
        lcd.locate(11,1);
        lcd.printf("Remover");
        lcd.locate(11,2);
        lcd.printf("Concluir");
        lcd.locate(11,3);
        lcd.printf("Cancelar");        
        movercursor(0,3,10);       
        if (bot_enter!=penter){
            if (linha==0){                
                func = 6;
                }
            else if (linha==1){
                if (pontos>=1){
                    machine.delete_last_saved();
                    pontos--;
                    maxpontos++;
                    func = 23;
                    }
                if (pontos==0){
                    func = 24;
                    }
                }
            else if (linha==2) {
                machine.kill_jog();
                pontos = 0;
                maxpontos = 100;
                func = 17;
                }
            else if (linha==3) {
                machine.kill_jog();
                wait(0.1);
                machine.cancel_program();
                pontos = 0;
                maxpontos = 100;
                func = 1;
                //pontos = 10;
                }
            }    
        }
        
    //func 3
    void automatico(){ //tela modo automatico
        
        lcd.cls();
        f = 0;
        sair = 0;
        bot_enter = penter;
        printf("Automatico\n\r");
        lcd.printf("Selecione o programa");
        arquivos();
        if (sair==1) {
            func = 1;
            }
        }
    
    //func 4
    void config() {
        
        lcd.cls();
        bot_enter = penter;
        lcd.locate(1,0);
        lcd.printf("Limpar seringa cola");
        lcd.locate(1,1);
        lcd.printf("Origem maquina");
        lcd.locate(1,2);
        lcd.printf("Modo WiFi");
        lcd.locate(1,3);
        lcd.printf("Voltar");
        movercursor(0,3,0);
        if (bot_enter!=penter){
            if (linha==2) {
                func = 13;
                }
            else if (linha==1) {
                func = 18;
                }
            else if (linha==0) {
                home = 1;
                func = 14;
                }
            else if (linha==3) {
                func = 1;
                }
            }        
        }
        
    //func 5
    void telasalvamento(){ //função para quando salvar um ponto
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Voce salvou");
        lcd.locate(1,1);
        lcd.printf("X:%.2f  ", cx_salva);
        lcd.locate(1,2);
        lcd.printf("Y:%.2f  ", cy_salva);
        lcd.locate(1,3);
        lcd.printf("Z:%.2f  ", cz_salva);
        lcd.locate(13,1);
        lcd.printf("Pontos");
        lcd.locate(13,2);
        lcd.printf("livres");
        lcd.locate(16,3);
        lcd.printf("%d", maxpontos);
        wait(1);
        if (pontos>0){
            func = 2;
            }
        else if (pontos==0){
            func = 2;
            }
        }
        
    //func 6
    void telacola(){ //tela para escolher o tipo de sequencia da cola
        
        lcd.cls();
        machine.kill_jog();
        bot_enter = penter;
        lcd.printf("P/ o proximo ponto:");
        lcd.locate(3,1);
        lcd.printf("Sem cola");
        lcd.locate(3,2);
        lcd.printf("Cola no ponto");
        lcd.locate(3,3);
        lcd.printf("Cola continua");
        movercursor(1,3,2);
        if (bot_enter!=penter){
            if (Mach.readable()){
                readSerial();
                }
            if (linha==1){
                cola = 0;
                if (pontos==0 && maxpontos>0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (pontos>=1 && maxpontos>0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (maxpontos==0){
                    func = 16;
                    }
                }
            else if (linha==2) {
                cola = 1;
                if (pontos==0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (pontos>=1 && maxpontos>0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (maxpontos==0){
                    func = 16;
                    }
                }
            else if (linha==3) {
                cola = 2;
                if (pontos==0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (pontos>=1 && maxpontos>0){
                    pontos++;
                    maxpontos--;
                    machine.save_point(cola,1.0);
                    printf("salvei ponto\n\r");
                    func = 2;
                    }
                else if (maxpontos==0){
                    func = 16;
                    }
                }            
            }
        }
    
    //func 7        
    void executarprograma() { //tela para selecionar se deseja executar o programa
        
        lcd.cls();
        bot_enter = penter;
        lcd.locate(2,0);
        lcd.printf("VOCE CONCLUIU SEU");
        lcd.locate(5,1);
        lcd.printf("PROGRAMA.");
        lcd.locate(0,2);
        lcd.printf("Deseja");
        lcd.locate(0,3);
        lcd.printf("executar?");
        lcd.locate(12,2);
        lcd.printf("Sim");
        lcd.locate(12,3);
        lcd.printf("Cancelar");
        movercursor(2,3,11);
        if (bot_enter!=penter) {
            if (linha==2){
                machine.kill_jog();
                wait(0.1);
                //machine.start_program();
                exec = 1;
                func = 9;
                }
            else if (linha==3){
                exec = 0;
                func = 1;
                }
            }
        }
    
    //func 8
    void telazerar(){ //tela para zerar a máquina
        
        lcd.cls();
        bot_enter = penter;
        machine.kill_jog();
        machine.jog();
        lcd.locate(1,0);
        lcd.printf("Selecione");
        lcd.locate(2,1);
        lcd.printf("um eixo");
        lcd.locate(1,2);
        lcd.printf("p/ zerar");
        lcd.locate(13,0);
        lcd.printf("X");
        lcd.locate(13,1);
        lcd.printf("Y");
        lcd.locate(13,2);
        lcd.printf("Z");  
        lcd.locate(13,3);
        lcd.printf("Voltar");          
        movercursor(0,3,12);
        if (bot_enter!=penter) {
            if (linha==0){
                cx = 0;
                func = 10;
                machine.set_zero("X");
                }
            else if (linha==1){
                cy = 0;
                func = 10;
                machine.set_zero("Y");
                }
            else if (linha==2){
                cz = 0;
                func = 10;
                machine.set_zero("Z");
                }
            else if (linha==3){
                func = 1;
                machine.kill_jog();
                }
            }
        }
        
    //func 9
    void executando(){ //tela de executando
        
        lcd.cls();
        machine.start_program();
        //printf("start program, %s\n\r", arquivo);
        lcd.locate(4,1);
        lcd.printf("Executando");
        //tpontinhos.start();
        while (exec == 1){
            if(emerg){
                func = 31;
                break;
            }
            if (Mach.readable()){
                readSerial();
                }
            }
        //printf("saiu\n\r");
        func = 11;
        }
    
    //func 10
    void zerado() { //tela avisando que a máquina foi zerada
        
        lcd.cls();
        lcd.locate(5,1);
        lcd.printf("Voce zerou");
        lcd.locate(6,2);
        lcd.printf("o eixo!");
        wait(1);
        func = 8;
        }
        
    //func 11
    void finalizado() { //tela aviso programa finalizado
        
        lcd.cls();
        lcd.locate(6,1);
        lcd.printf("PROGRAMA");
        lcd.locate(5,2);
        lcd.printf("FINALIZADO");
        wait(1);
        func = 1;
        }     
        
    //func 12
    void limpeza_livre(){
        
        lcd.cls();
        bot_enter = penter;
        lcd.printf("CERTIFIQUE-SE DE QUE A MAQUINA PODE SE");
        lcd.locate(5,2);
        lcd.printf("MOVIMENTAR.");
        lcd.locate(9,3);
        lcd.printf("OK");
        movercursor(3,3,8);
        if (bot_enter!=penter){
            if (linha==3){
                //printf("vai home\n\r");
                home = 1;
                func = 27;
                }
            }
        }
    
    //func 13
    void wifi(){
        bot_enter = penter;
        lcd.cls();
        lcd.locate(2,0);
        lcd.printf("Modo WiFi Ativo"); 
        lcd.locate(6,3);
        lcd.printf("Cancelar");
        movercursor(3,3,5);
                if (bot_enter!=penter){
            if (linha==3){
                func = 1;
                }
            }   
        }
    
    //func 14
    void limparcola(){
        lcd.cls();
        bot_enter = penter;
        lcd.locate(2,0);
        lcd.printf("Deseja limpar a");
        lcd.locate(2,1);
        lcd.printf("seringa de cola?");
        lcd.locate(6,2);
        lcd.printf("Sim");
        lcd.locate(6,3);
        lcd.printf("Cancelar");
        movercursor(2,3,5);
        if (bot_enter!=penter) {
            if (linha==2){
                printf("sim home\n\r");
                func = 28;
                }
            else if (linha==3){
                func = 4;
                }
            }
        }
    
    //func 15
    void gohome(){
        
        lcd.cls();
        lcd.locate(2,1);
        printf("indo home\n\r");
        lcd.printf("Movimentando...");
        machine.machine_zero();
        while (home == 1){
            if(emerg){
                func = 31;
                break;
            }
            if (Mach.readable()){
                readSerial();
                }
            }
        func = 19;
        }
    
    //func 16
    void limitepontos(){ //tela para quando acabam os pontos
        
        lcd.cls();
        lcd.printf(" Voce atingiu o n%c   maximo de pontos", 0xDF);
        lcd.locate(9,2);
        lcd.printf("(%d)", pontos);
        lcd.locate(0,3);
        lcd.printf("Conclua seu programa");
        wait(1);
        func = 2;
        }   
    
    //func 17
    void salvarprog(){
        
        lcd.cls();
        bot_enter = penter;
        nome = "";
        lcd.printf("Voce deseja salvar  este programa?");
        lcd.locate(8,2);
        lcd.printf("Sim");
        lcd.locate(8,3);
        lcd.printf("Nao");
        movercursor(2,3,7);
        if (bot_enter!=penter){
            if (linha==2){
                salvar = 1;
                //printf("salvar\n\r");
                func = 20;
                }
            if (linha==3){
                salvar = 0;
                func = 7;
                }
            }
        }
    
    //func 18
    void ctzhome(){
        
        lcd.cls();
        bot_enter = penter;
        lcd.printf("CERTIFIQUE-SE DE QUE A MAQUINA PODE SE");
        lcd.locate(5,2);
        lcd.printf("MOVIMENTAR.");
        lcd.locate(9,3);
        lcd.printf("OK");
        movercursor(3,3,8);
        if (bot_enter!=penter){
            if (linha==3){
                home = 1;
                func = 15;
                }
            }
        }
        
    //func 19
    void origem(){
        
        lcd.cls();
        lcd.locate(5,1);
        lcd.printf("A MAQUINA");
        lcd.locate(2,2);
        lcd.printf("ESTA NA ORIGEM");
        wait(1);
        func = 4;
        }
        
    //func 20
    void nomeprog(){
        
        lcd.cls();
        sair = 0;
        bot_enter = penter;
        voltar = 0;
        lcd.locate(2,0);
        lcd.printf("Escolha o nome:");
        lcd.locate(0,3);
        lcd.printf("Segure V para salvar");
        coluna = 1;        
        escrever();
        if (sair==1){
            lcd.cls();
            lcd.locate(10,3);
            lcd.printf("Aguarde...");
            int len = nome.length();
            nome.erase(len - 1);
            nome.append(".txt");
            int verificar = sdcard.check_name_available(nome);
            printf("%d\n\r", verificar);
            if (verificar==1){
                printf("entre\n\r");
                file_name = nome;
                machine.get_saved_points();
                while(1){
                    if(Mach.readable()){
                        readSerial();
                        break;
                        }
                    }
                printf("ok\n\r");
                func = 25;
                }
            else if (!verificar){
                func = 21;
                printf("nok\n\r");
                }
            }
        }
        
    //func 21
    void mudar_nome(){
        
        lcd.cls();
        lcd.printf("ESCOLHA OUTRO NOME");
        wait(1);
        func = 20;
        }
        
    //func 22
    void salva2(){
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Voce salvou o ponto:");
        lcd.locate(5,1);
        lcd.printf("X:");
        lcd.locate(5,2);
        lcd.printf("Y:");
        lcd.locate(5,3);
        lcd.printf("Z:");
        //x
        if (cx<=-1 && cx>=-9){                    
            lcd.locate(7,1);
            lcd.printf("  %.2f ", cx);
            }
        if (cx<=-10 && cx>=-99){
            lcd.locate(7,1);
            lcd.printf(" %.2f ", cx);
            }
        if (cx<=-100){
            lcd.locate(7,1);
            lcd.printf("%.2f ", cx);
            }                        
        if (cx<=9 && cx>=0){                    
            lcd.locate(7,1);
            lcd.printf("   %.2f ", cx);
            }
        if (cx>=10 && cx<=99){
            lcd.locate(7,1);
            lcd.printf("  %.2f ", cx);
            }
        if (cx>=100){
            lcd.locate(7,1);
            lcd.printf(" %.2f ", cx);
            }
        //y
        if (cy<=-1 && cy>=-9){                    
            lcd.locate(7,2);
            lcd.printf("  %.2f ", cy);
            }
        if (cy<=-10 && cx>=-99){
            lcd.locate(7,2);
            lcd.printf(" %.2f ", cy);
            }
        if (cy<=-100){
            lcd.locate(7,2);
            lcd.printf("%.2f ", cy);
            } 
        if (cy<=9 && cy>=0){                    
            lcd.locate(7,2);
            lcd.printf("   %.2f ", cy);
            }
        if (cy>=10 && cx<=99){
            lcd.locate(7,2);
            lcd.printf("  %.2f ", cy);
            }
        if (cy>=100){
            lcd.locate(7,2);
            lcd.printf(" %.2f ", cy);
            }
        //z
        if (cz<=-1 && cz>=-9){                    
            lcd.locate(7,3);
            lcd.printf("  %.2f ", cz);
            }
        if (cz<=-10 && cx>=-99){
            lcd.locate(7,3);
            lcd.printf(" %.2f ", cz);
            }
        if (cz<=-100){
            lcd.locate(7,3);
            lcd.printf("%.2f ", cz);
            }
        if (cz<=9 && cz>=0){                    
            lcd.locate(7,3);
            lcd.printf("   %.2f ", cz);
            }
        if (cz>=10 && cx<=99){
            lcd.locate(7,3);
            lcd.printf("  %.2f ", cz);
            }
        if (cz>=100){
            lcd.locate(7,3);
            lcd.printf(" %.2f ", cz);
            }
        wait(1);
        func = 2;
        }
    
    //func 23
    void deletepoint(){
        
        lcd.cls();
        lcd.locate(3,1);
        lcd.printf("Voce removeu o");
        lcd.locate(4,2);
        lcd.printf("ultimo ponto");
        //lcd.locate(2,2);
        //lcd.printf("ESTA NA ORIGEM");
        wait(1);
        func = 2;
        }
        
    //func 24
    void sempontos(){
        
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("Nao existem pontos");
        lcd.locate(1,2);
        lcd.printf("salvos p\ remover.");
        wait(1);
        func = 2;
        }
        
    //func 25
    void salvando_arq(){
        printf("salvou");
        lcd.cls();
        lcd.locate(5,1);
        lcd.printf("Salvando");
        lcd.locate(1,2);
        //lcd.printf("%s", nome);
        wait(1);
        func = 7;
        }
    
    //func 26
    void exec_auto(){
        
        lcd.cls();
        bot_enter = penter;
        lcd.locate(2,0);
        lcd.printf("DESEJA EXECUTAR?");
        lcd.locate(3,1);
        //lcd.printf("%s", arquivo);
        lcd.locate(6,2);
        lcd.printf("Sim");
        lcd.locate(6,3);
        lcd.printf("Cancelar");
        movercursor(2,3,5);
        if (bot_enter!=penter) {
            if (linha==2){
                //machine.kill_jog();
                wait(0.1);
                //machine.start_program();
                exec = 1;
                func = 9;
                }
            else if (linha==3){
                exec = 0;
                func = 1;
                }
            }
        }
        
    //func 27
    void indo_limpeza(){
        
        lcd.cls();
        lcd.locate(2,1);
        printf("indo home\n\r");
        lcd.printf("Movimentando...");
        machine.machine_zero();
        while (home == 1){
            if(emerg){
                func = 31;
                break;
            }
            if (Mach.readable()){
                readSerial();
                }
            }
        func = 28;
        }
    
    //func 28
    void chegou_limpeza(){
        
        lcd.cls();
        bot_enter = penter;
        machine.jog();
        printf("foi home\n\r");
        lcd.locate(4,0);
        lcd.printf("Posicione um");
        lcd.locate(5,1);
        lcd.printf("recipiente");
        lcd.locate(3,2);
        lcd.printf("abaixo do bico");
        lcd.locate(7,3);
        lcd.printf("PRONTO");
        movercursor(3,3,6);
        if (bot_enter!=penter){
            if (linha==3){
                printf("vai cola\n\r");
                limpar_cola = 1;
                func = 29;
                }
            }
        
        }
    
    //func 29
    void limpando(){
        
        lcd.cls();
        bot_enter = penter;
        lcd.locate(5,1);
        printf("indo cola\n\r");
        lcd.printf("Limpando...");
        lcd.locate(8,3);
        lcd.printf("Parar");
        machine.clean_glue();
        movercursor(3,3,7);
        while (limpar_cola == 1 && bot_enter==penter){
            if(emerg){
                func = 31;
                break;
            }
            if (Mach.readable()){
                readSerial();
                }
            }
        if (bot_enter!=penter){
                machine.clean_glue();
                machine.kill_jog();
                func = 30;
                }
        }
    
    //func 30
    void limpeza_completa(){
        
        lcd.cls();
        lcd.locate(1,1);
        printf("foi cola\n\r");
        lcd.printf("Limpeza completa!");
        wait(1);
        func = 4;
        }
        
    //func 31
    void tela_emergencia(void){
        
        lcd.cls();
        machine.kill_jog();
        lcd.locate(0,1);
        lcd.printf("BOTAO DE EMERGENCIA");  
        lcd.locate(4,2);
        lcd.printf("PRESSIONADO.");
        printf("Waiting release...");
        func = 1;
        while(!emergencia.read()); 
        }
    
        
    //função ler arquivos
    void arquivos(){
        
        exec = 0;
        int nomearq;
        nomearq = sdcard.get_file_names();
        int ftamanho = filenames.size();
        int fmax = ftamanho - 1;
        int fant = 1;
        while (sair==0){
            if(emerg){
                func = 31;
                break;
            }
            if (bot_cima==0){
                fant = f;
                f--;
                if (f<0){
                    f = fmax;
                    }
                bot_cima = 1;                        
                }
            if (bot_baixo==0){
                fant = f;
                f++;
                if (f>fmax){
                    f = 0;
                    }
                bot_baixo = 1;
                }
            arquivo = filenames[f];
            if (f!=fant){
                lcd.locate(0,1);
                lcd.printf("                    ");
                lcd.locate(0,2);
                lcd.printf("                    ");
                lcd.locate(0,1);
                lcd.printf("%s", arquivo); 
                }
            if (bot_enter!=penter){
                lcd.locate(10,3);
                lcd.printf("Aguarde...");
                sdcard.send_gcode(arquivo);
                printf("send gcode, %s\n\r", arquivo);
                func = 26;
                break;
                }      
            fant = f;            
            }
        }
        
                
    //função para escrever nome arquivo
    void escrever(){
        
        char alfabeto[38] = {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
        '0','1','2','3','4','5','6','7','8','9','-','_'};
        int imax = 37;
        int imin = 0;
        nome = "";
        while (sair==0){
            if(emerg){
                func = 31;
                break;
            }
            voltar = 0;
            int i = 0;
            //lcd.locate(0,2);
            //lcd.setCursor(TextLCD::CurOn_BlkOn);
            lcd.locate(1,1);
            lcd.printf("%s", nome);
            while (bot_enter==penter){
                if(emerg){
                    func = 31;
                    break;
                }
                if (bot_cima == 0){
                    if (i==imin){
                        i = imax;
                        }
                    else if (i>imin && i<=imax){
                            i--;
                        }
                    bot_cima = 1;
                    }
                else if (bot_baixo == 0){
                    if (i==imax){
                        i = imin;
                        }
                    else if (i<imax && i>=imin){
                        i++;
                        }
                    bot_baixo = 1;
                    }  
                lcd.locate(coluna, 1);
                lcd.printf("%c", alfabeto[i]);
                lcd.locate(coluna,2);
                lcd.printf("%c", 0x5E);
                
                if(timer.read() > 1.0){
                    sair = 1;  
                    printf("SAINDO\n\r");  
                    timer.reset();
                    timer.stop();
                    break;
                    }
                if(timer2.read() > 1.0){
                    voltar = 1;  
                    printf("APAGANDO\n\r"); 
                    timer2.reset();
                    timer2.stop(); 
                    break;
                    }
                }   
            
            if (nome.size()<14 && coluna<=14){
                char carac = alfabeto[i];
                nome.push_back(carac);
                bot_enter = penter;
                if (coluna<=14){
                    if (voltar==1){
                        //printf("voltar\n\r");
                        if (coluna>1){
                            //nome[coluna-1]="";
                            lcd.locate(coluna, 1);
                            lcd.printf(" ");
                            lcd.locate(coluna, 2);
                            lcd.printf(" ");
                            coluna--;
                            nome.erase(coluna-1);
                            lcd.locate(coluna, 2);
                            lcd.printf("%c", 0x5E);
                            }
                        }
                    if (voltar==0 && coluna<14){
                        lcd.locate(coluna, 2);
                        lcd.printf(" ");
                        coluna++;
                        lcd.locate(coluna, 2);
                        lcd.printf("%c", 0x5E);
                        }
                    }
                }
            }
        }
        
    
        
    //função para ler os pontos
    void readSerial(){
        char recv;
        int points = 0;
        int pointx = 0;
        int pointy = 0;
        int pointz = 0;
        int action = 0;
        int uploading_saved = 0;
        string coordx = "";
        string coordy = "";
        string coordz = "";
        string recv_buffer;
        
        int status;
    
     
        while(1){
            recv = Mach.getc();
            printf("%c\n\r", recv);
            
            if(emerg){
                func = 31;
                break;
            }
            
            if (recv == 'a'){
                home = 0;
                exec = 0;
                limpar_cola = 0;
                printf("oi\n\r");
                action = 1;
                WiFi.putc('ax');
            }
                
            if (recv == 'p'){
                points = 1;
                printf("p\n\r");
            }
                
            if(recv == 'u'){
                uploading_saved = 1;    
            }
            
            if(uploading_saved){
                if(recv == 'x'){
                    printf("OK\n\r");   
                    status = sdcard.save_GCODE(file_name, recv_buffer);
                    return;
                } 
                else if(recv != 'u'){
                    recv_buffer.push_back(recv);
                }
            }         
            
            if (points && !uploading_saved){                
                if (recv == 'X'){
                    pointx = 1;
                    pointy = 0;
                    pointz = 0;
                    }
                else if (recv == 'Y'){
                    pointy = 1;
                    pointx = 0;
                    pointz = 0;
                    }
                else if (recv == 'Z'){
                    pointz = 1;
                    pointx = 0;
                    pointy = 0;
                    }
                else if(recv == 'x'){
                    cx = atof(coordx.c_str());
                    cy = atof(coordy.c_str());
                    cz = atof(coordz.c_str());
                    //printf("%s,%s,%s\n\r", coordx, coordy, coordz);
                    break;
                    }
                }
                
            if(pointx){
                if (recv!='X'){
                    coordx.push_back(recv);
                    }
            }
            if (pointy){
                if (recv!='Y'){
                    coordy.push_back(recv);
                    }
            }
            if (pointz){
                if (recv!='Z'){
                    coordz.push_back(recv);
                    }
            }
            if (action){
                if (recv=='x'){
                     break;
                    }
            } 
            t1.reset();
            t1.start();
            tempo = 2;
            if (t1.read()>tempo){
                break;
            }
        }
    }
    
    
                    
    Menu(); //não apagar
};