/*CÓDIGO PARA LCD MENU HELLEN - GRUPO T*/

#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "string"
#include "vector"

Timer timer;
Timer timer2;
Timer enter_debounce_timer;
Timer cima_debounce_timer;
Timer baixo_debounce_timer;
Timer tpontinhos;
Timer wifi_serial;
Timer clean_wifi;
Timer t1;
Timer t2;
Timer t3;
 
//I2C Communication
I2C i2c_lcd(D14,D15); // SDA, SCL //não apagar

//Botão push
InterruptIn botao_enter(D12);
InterruptIn botao_cima(D9);
InterruptIn botao_baixo(D13);

InterruptIn emergencia(D3);

DigitalOut ledAzul(D5);
DigitalOut ledAmarelo(D6);
DigitalOut ledVerm(D7);

//LCD instantiation 
TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD20x4); //não apagar

//variáveis int
int bot_enter = 0;
int bot_cima = 0;
int bot_baixo = 0;
int penter = 1;
int pcima = 1;
int pbaixo = 1;
int cola;
int exec;
int select = 0;
int pontos = 0;
int salvar = 0;
int maxpontos = 100;
int home;
int coluna = 1;
int contador = 0;
int sair = 0;
int voltar = 0;
int quebrar = 0;
int f = 0;
int limpar_cola = 0;
int tempo;

int jog_working = 0;
int emerg = 0;

//variáveis float
float cx = 120.45;
float cy = 457.85;
float cz = 782.65;
float cx_salva;
float cy_salva;
float cz_salva;

//funções interrupt
void botenter_press(void);
void botcima_press(void);
void botbaixo_press(void);
void botbaixo_release(void);
void botcima_release(void);
void emergencia_press(void);
void emergencia_release(void);
void wifiRx(void);


#include "classes.h"

Menu::Menu(){ //não apagar
    func = 0;
    }

Menu menu;  

int main () {
    printf("Starting...\n\r");
    lcd.setBacklight(TextLCD::LightOn); //liga backlight
    lcd.setCursor(TextLCD::CurOff_BlkOff); //define tipo de cursor
        
    botao_enter.fall(&botenter_press); //chama função botao enter
    botao_cima.fall(&botcima_press); //chama função botao para cima
    botao_baixo.fall(&botbaixo_press); //chama função bota para baixo
    
    botao_baixo.rise(&botbaixo_release); //chama função ler timer
    botao_cima.rise(&botcima_release);
    
    enter_debounce_timer.start(); // não apagar
    cima_debounce_timer.start();
    baixo_debounce_timer.start();
       
    emergencia.fall(&emergencia_press);
    emergencia.rise(&emergencia_release);
    
    ledAzul = 1;
    ledAmarelo = 1;
    ledVerm = 1;
    
    if(!emergencia.read()){
        printf("EMERGENCIA PRESSIONADO\n\r");
        menu.tela_emergencia();
        while(!emergencia.read());
        printf("OK\n\r");
    }
       
    while(1){
        switch(menu.func){ //faz com que as telas sejam iniciadas
            case 0: menu.inicializar(); break;
            case 1: menu.menuprincipal(); break;
            case 2: menu.jog(); break;
            case 3: menu.automatico(); break;
            case 4: menu.config(); break;
            case 5: menu.telasalvamento(); break;
            case 6: menu.telacola(); break;
            case 7: menu.executarprograma(); break;
            case 8: menu.telazerar(); break;
            case 9: menu.executando(); break;
            case 10: menu.zerado(); break;
            case 11: menu.finalizado(); break;
            case 12: menu.limpeza_livre(); break;
            case 13: menu.wifi(); break;
            case 14: menu.limparcola(); break;
            case 15: menu.gohome(); break;
            case 16: menu.limitepontos(); break;
            case 17: menu.salvarprog(); break;
            case 18: menu.ctzhome(); break;
            case 19: menu.origem(); break;
            case 20: menu.nomeprog(); break;
            case 21: menu.mudar_nome(); break;
            case 22: menu.salva2(); break;
            case 23: menu.deletepoint(); break;
            case 24: menu.sempontos(); break;
            case 25: menu.salvando_arq(); break;
            case 26: menu.exec_auto(); break;
            case 27: menu.indo_limpeza(); break;
            case 28: menu.chegou_limpeza(); break;
            case 29: menu.limpando(); break;
            case 30: menu.limpeza_completa(); break;
            case 31: menu.tela_emergencia(); break;
        }
    } 
}             
        
//função interrupt botão enter        
    void botenter_press(void){ 
    printf("ENTER!\n\r");
    //printf("timer: %.3f\n\r", enter_debounce_timer.read());
        if(enter_debounce_timer.read()>0.2){        
            penter = bot_enter;
            bot_enter = !bot_enter;
            //printf("enter high, timer reset FALL\n\r");
            //timer.reset();
           // timer.start();
            enter_debounce_timer.reset();
            enter_debounce_timer.start();
            }
        }
          
//função interrupt botão cima          
    void botcima_press(void){
        printf("CIMA!\n\r");
        //printf("timer: %.3f\n\r", cima_debounce_timer.read());
        //printf("timer: %.3f\n\r", baixo_debounce_timer.read());
        if(cima_debounce_timer.read()>0.2){        
            pcima = bot_cima;
            bot_cima = !bot_cima;
            timer2.reset();
            timer2.start();
            cima_debounce_timer.reset();
            cima_debounce_timer.start();
            }
        }

//função interrupt botão baixo          
    void botbaixo_press(void){
        printf("BAIXO!\n\r");
        //printf("timer: %.3f\n\r", baixo_debounce_timer.read());
        if(baixo_debounce_timer.read()>0.2){        
            pbaixo = bot_baixo;
            bot_baixo = !bot_baixo;
            timer.reset();
            timer.start();
            baixo_debounce_timer.reset();
            baixo_debounce_timer.start();
            }
        }
        
//função para ler o timer          
    void botbaixo_release(void){
        timer.stop();
        quebrar = 1;
        }
        

//função para ler o timer 2     
    void botcima_release(void){
        timer2.stop();
        //printf("%f,%d, timer 2 RISE\n\r", t2, voltar);
        }
        
void wifiRx(void){
    clean_wifi.reset();
    clean_wifi.start();
    printf("FUNC WIFI!\n\r");
    wifi_serial.reset();
    float timeout_time = 2.0;
    
    char recv;
    string buffer;
    
    int glue = 0;
    int jog_mode = 0;
    int kill_jog_mode = 0;
    int move_mode = 0;
    int zero_mode = 0;
    int machine_zero_mode = 0;
    int upload_code = 0;
    int start_mode = 0;
    wifi_serial.start();
        
    while(1){
        recv = WiFi.getc();
        printf("Recv: %c\n\r", recv);   
        
        if(wifi_serial.read() > timeout_time){
            wifi_serial.stop();
            printf("Serial timeout");
            break;   
        }
        
        if(recv == 'x'){
            printf("Jog: %d, Kill Jog: %d, Glue: %d, Move: %d, Start: %d\n\r", jog_mode, kill_jog_mode, glue, move_mode, start_mode);
            if(glue){
                machine.clean_glue();
                lcd.locate(0,1);
                lcd.printf("Modo cola           ");
            } else if(jog_mode){
                if(kill_jog_mode){
                    machine.kill_jog();
                    lcd.locate(0,1);
                    lcd.printf("Modo desabilitar JOG");
                } else {
                    machine.jog();
                    lcd.locate(0,1);
                    lcd.printf("Habilitar JOG       ");
                }
            } else if(move_mode){
                machine.move(buffer);
                wait(1);
                machine.start_program();
                lcd.locate(0,1);
                lcd.printf("Modo mover        ");
            } else if(zero_mode){
                if(machine_zero_mode){
                    machine.machine_zero(); 
                    lcd.locate(0,1);
                    lcd.printf("Zerar maquina       ");  
                }    
            } else if(start_mode){
                machine.start_program();    
            } else if(upload_code){
                machine.move(buffer); 
                lcd.locate(0,1);
                lcd.printf("Modo carregar codigo");
            }
            return;
        }
        
        if(recv == 'g'){
            glue = 1;
        }
        
        if(recv == 'b'){
            start_mode = 1; 
        }
        
        if(recv == 'j'){
            jog_mode = 1;
        }
        
        if(recv == 'k' && jog_mode){
            kill_jog_mode = 1;   
        }
        
        if(recv == 'z'){
            zero_mode = 1;  
        }
        
        if(recv == 'm' && zero_mode){
            machine_zero_mode = 1;    
        }
        
        if(recv == 'm' && !zero_mode){
            printf("MOVE!\n\r");
            buffer = "u";
            move_mode = 1;
        }
        
        if(recv == 'u'){
            buffer = "u";
            timeout_time = 10.0;
            upload_code = 1;   
        }
        
        if(move_mode && recv != 'm'){
            buffer.push_back(recv); 
        }
        
        if(upload_code && recv != 'u'){
            buffer.push_back(recv);  
        }
    } 
}
    
void emergencia_press(void){
    printf("Emerg Press\n\r");
    emerg = 1;
}

void emergencia_release(void){
    printf("Emerg Release\n\r");
    emerg = 0;
}