/*
 License:
  Copyright (C) 2017 GroveStreams LLC.
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at: http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
 
#ifndef LCDDISCOF746NG_H_
#define LCDDISCOF746NG_H_

#include "LCD_DISCO_F746NG.h"

class LcdDiscoF746NgTracer
{
protected:
    int _line;
    int _maxLines;
    LCD_DISCO_F746NG _lcd;

public:

    /** Constructor
    *
    */
    LcdDiscoF746NgTracer();

    /** Prints formatted strings to the LCD in a single line for each call. Long  
    * lines are wrapped. The LCD is cleared after it is full. 
    * Utilizes sprintf. sprintf does not support floats on many
    * embed systems.
    *
    * \param format string format. 
    * \param ... variable number of format arguments 
    *  Example: printf("Successful update");
    *  Example: printf("Current status: %d", status);
    * \return 0 on success
    */
    void printf(const char* format, ...);
    
    /** Prints a string to the LCD in a single line for each call. Long  
    * lines are wrapped. The LCD is cleared after it is full. 
    *
    * \param sbuffer string buffer 
    */
    void println(const char* sbuffer);    
    
    /** Clears the LCD
    *
    */
    void clear();
};

#endif /* LCDDISCOF746NG_H_ */