/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: display.cpp
* Purpose: Contain function definitions
* 
* Created: 03/01/2018
* Last Modified: 03/29/2018
*
******************************************************************************/
#include "mbed.h"
#include "io_pins.h"
#include "display.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "spi.h"
#include "utility.h"

//#define VERSION1
#define VERSION2

extern SPI wag_spi;
extern spi_cfg as1107;
extern Serial pc;

/*
 * void initial_setup(struct spi_cfg spi_obj);
 * Description: setup spi data length (in bit), spi frequency, set LED 
 *              display to normal operation, and set all display numbers
 *              to 0.
 * 
 * Inputs: 
 *      Parameters:
 *          struct spi_cfg spi_obj: spi_cfg object 
 *      
 * Outputs:
 *      Returns: void
*/
void initial_setup(struct spi_cfg spi_obj) {
    spi_obj.spi_ncs = 1; 
    
    spi_send(spi_obj, 0x0C01);
    spi_send(spi_obj, 0x090F);
    spi_send(spi_obj, 0x0F00);
    spi_send(spi_obj, 0x0A0F);
    spi_send(spi_obj, 0x0B04);
    spi_send(spi_obj, 0x0100);
    spi_send(spi_obj, 0x0200);
    spi_send(spi_obj, 0x0300);
    spi_send(spi_obj, 0x0400);
    spi_send(spi_obj, 0x0500);
}




#ifdef VERSION1
/*
 * void bin2bcd_array(int num);
 * Description: Converts to BCD array using modulo method.
 *
 * Inputs: 
 *      Parameters:
 *          int num: number to push to display
            char bcd[]: BCD array that will be written to
 *      Globals:
 *      
 * Outputs:
 *      Returns: void
*/
void bin2bcd_array(int num, char bcd[]) {
    int place = 0;
    while (num != 0) { //converts decimal input to decimal array using %mod
        int val = num % 10;
        bcd[place] = val; 
        num = num/10;
        place++;
    }
}
#endif

#ifdef VERSION2
/*
 * void bin2bcd_array(int num);
 * Description: converts a number from binary format to binary coded
 *              decimal array using sprintf() method
 *
 * Inputs: 
 *      Parameters:
 *          int num: number in binary format
 *          char bcd[]: bcd (binary coded decimal) array
 *      
 * Outputs:
 *      Returns: void
*/
void bin2bcd_array(int num, char bcd[]) {
    char tmp_array[4];
    char reverse_bcd[4];
    int last_index = 0;
    int i = 0;
    
    sprintf(tmp_array, "%d", num);
    for (i = 0; i < 4; i++) {
        bcd[i] = 0;
        reverse_bcd[i] = 0;
    }
    
    while (last_index < 4 and tmp_array[last_index] != '\0') {
        reverse_bcd[last_index] = tmp_array[last_index] - '0';   
        last_index++;    
    }
    
    // reverse the order to fit binary coded decimal
    for (i = 0; i < last_index; i++) {
        bcd[i] = reverse_bcd[last_index - 1 - i];
    }
}
#endif

/*
 * void send_command_to_display(char bcd[]);
 * Description: send bcd[] array to the display driver to display number
 *              in the display
 *
 * Inputs: 
 *      Parameters:
 *          char bcd[]: bcd (binary coded decimal) array
 *      
 * Outputs:
 *      Returns: void
*/
void send_command_to_display(char bcd[]) {
    int command;
    
    
    for (int i = 1; i <= 4; i++) {
        command = 0;
        // command has following form: 0x0[place]0[value]
        // the value converted to int is 16 * 16 * place + value
        command = 16 * 16 * i + bcd[i - 1]; 
        spi_send(as1107, command);
    }
}

/*
 * void test_target_leds();
 * Description: test each LED on the target board
 *
 * Inputs: 
 *      None
 *      
 * Outputs:
 *      Returns: void
*/
void test_target_leds() {
    int led_command = 0;
    while (uti_chk_ubutton() == 0);
    pc.printf("test begin\n");
    while (uti_chk_ubutton() == 0) {
        for (int i = 1; i <= 128; i = i * 2) { 
            led_command = 0x0500 + i;
            pc.printf("led_command: %d\n", led_command);
            spi_send(as1107, led_command); //light up LED[i]
            wait(0.1);
            spi_send(as1107, 0x0500); //turn off LED[i]
        }
    }
}
