/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: analog.cpp
* Purpose: Analog functions
*
* Created: 03/20/2018
* Last Modified: 03/20/2018
*
******************************************************************************/

#include "mbed.h"
#include "io_pins.h"
#include "utility.h"
#include "analog.h"
#include "laser.h"
#include "stepper.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

extern BusOut mux_select;
extern AnalogIn mux_out;
extern DigitalIn cal_button;
extern DigitalOut laser;
extern Serial pc;
extern DigitalIn jog_ccw;
extern DigitalIn jog_cw;
float phototransistor_array[MUX_CHANS];

/*
 * void ana_init();
 * Description: sets mux select bits to zero
 *
 * Inputs: 
 *      Parameters:
 *      Globals:
 *      
 * Outputs:
 *      Returns: void
*/
void ana_init() {
    mux_select = 0;     // set all mux select bits to zeros
}

/*
 * void ana_scan_mux(float * an_array, int no_of_channels);
 * Description: sets mux select bits to respective channels
 *
 * Inputs: 
 *      Parameters:
 *          float * an_array: pointer to channel array
 *          int no_of_channels: number of channels to cycle through
 *      Globals:
 *      
 * Outputs:
 *      Returns: void
*/
void ana_scan_mux(float * an_array, int no_of_channels) {
    for (int i = 0; i < no_of_channels; i++) {
        mux_select = i;
        an_array[i] = mux_out.read();
    }
}

/*
 * void test_phototransistors();
 * Description: scan the value of phototransistors on WAG board
 *
 * Inputs: 
 *      Parameters:
 *      Globals:
 *      
 * Outputs:
 *      Returns: void
*/
void test_phototransistors () {
    // check for button pressed and released to start PT scan test
    while (uti_chk_ubutton() == 0);
    pc.printf("test begin\n");
    stp_init();
    while (uti_chk_ubutton() == 0) {
        
        if (jog_ccw == 0) {
            stp_step(STP_CCW);
            wait(0.01);
        }
        if (jog_cw == 0) {
            stp_step(STP_CW);
            wait(0.01);
        }
        
        if (cal_button.read() == 0) {
            if (laser == 0)
                lzr_on();
            else
                lzr_off();
            wait(0.02);
        }
        
        ana_scan_mux(phototransistor_array, MUX_CHANS);
        for (int i = 0; i < MUX_CHANS; i++) {
            pc.printf("%d: %.3f   ", i, phototransistor_array[i] * 3.3f);   
        }
        pc.printf("\e[1;1H\e[2J");
    }
    lzr_off();
}