/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 7: WaG
*
* Authors: Sam Morrison and Phong Nguyen
* File name: wag.cpp
* Purpose: Wag functions
*
* Created: 04/12/2018
* Last Modified: 04/12/2018
*
******************************************************************************/

#include "mbed.h"
#include "io_pins.h"
#include "wag.h"
#include "spi.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

Timer t;
extern spi_cfg as1107;
extern int stp_sensor_pos[TGT_SENSOR_QUAN];

int led_values[8] = {1, 2, 4, 8, 16, 32, 64, 128};

/*
 * void gnoll(int sensor_no, float * sensor_values)
 * Description: function for gnoller
 *
 * Inputs:
 *      Parameters:
 *          int sensor_no: station indicator 
 *          float * sensor_values: a float array that stores 16 sensor values
 *      Globals:
 *
 * Outputs:
 *      Returns: void
*/
void gnoll(int sensor_no, float * sensor_values)
{
    int hit = 0;
    int miss = 0;
    int a_num;
    int led_command;
    int msec;

    int whacker_no = 0;

    if (sensor_no == 0)
        whacker_no = 8;
    
    
    srand(time(NULL));
    // run through 15 volleys 
    for (int i = 0; i < 15; i++) {
        pc.printf("Round %d\n", i + 1);
        a_num = rand() % 8; // create random number 0-7
        pc.printf("Random number: %d. Stepper position: %d.", a_num, stp_sensor_pos[a_num]);
        turn_to_target(stp_sensor_pos[a_num]); // turn motor to random target
        lzr_on(); // turn laser on
        wait(LASER_DELAY); // wait for laser to activate

        ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2); // scan all sensors
        wait(LED_DELAY);
        
        // confirm that the sensor is high
        if (sensor_values[sensor_no + a_num] * 3.3 > PTTHRESH) { 
            led_command = 0x0500 + led_values[a_num]; // create SPI command for LED
            //pc.printf("led_command: %d\n", led_command);
            spi_send(as1107, led_command); // light up LED
            //pc.printf("done sent\n");
            pc.printf("led_command: %d\n", led_command);
            wait(LED_DELAY);
            // NOTE: must put a wait() here or else the led won't light up
        } 
        // laser failed to hit sensor
        else {
            pc.printf("sensor value: %f\n" ,sensor_values[sensor_no + a_num] * 3.3);
            pc.printf("Error: sensor not activated. Shutting down.\n");
            while(1);
        }

        // start a timer to wait for whacker to hit target
        clock_t start = clock();
        pc.printf("Waiting for whacker...\n");

        // scan sensors for timer duration or until whacker hits
        do {
            ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2); // scan all sensors
            clock_t difference = clock() - start;
            msec = difference * 1000 / CLOCKS_PER_SEC;
            //pc.printf("Time elapsed: %d. Time limit: %d\n", msec, VOLLEY_DELAY);
        } while (msec < VOLLEY_DELAY and sensor_values[whacker_no + a_num] * 3.3 < PTTHRESH); // check if timer expired or if sensor hit

        // whacker hit target within time
        if (sensor_values[whacker_no + a_num] * 3.3 > PTTHRESH) {
            hit++; // increment hit count
            pc.printf("Hit\n");
            //while(sensor_values[whacker_no + a_num] * 3.3 > PTTHRESH)
              //  ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2); // waits for whacker laser to turn off
        }

        else {
            // go through all whacker sensors
            for (int j = 0 + whacker_no; j < 8 + whacker_no; j++) { 
                // check if wrong sensor hit
                if (sensor_values[i + whacker_no] * 3.3 > PTTHRESH and j != a_num) { 
                    pc.printf("Sensor: %d. Sensor value:%f\n", j, sensor_values[i + whacker_no] * 3.3);
                    pc.printf("Wrong sensor hit.\n");
                    i = 15; // ends volley
                    ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2); // scan all sensors
                    while(sensor_values[i + whacker_no] * 3.3 > PTTHRESH)
                        ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2); // waits for whacker laser to turn off
                }
            }
            // log miss regardless
            pc.printf("Miss\n");
            miss++; // increment miss count
        }
        // turn laser off and update scoreboard
        lzr_off();
        spi_send(as1107, 0x0500);
        pc.printf("Hit: %d. Miss: %d.", hit, miss);
        update_score(hit, miss);
    }
}

/*
 * void whack(int sensor_no, float * sensor_values)
 * Description: function for whacker
 *
 * Inputs:
 *      Parameters:
 *          int sensor_no: station indicator 
 *          float * sensor_values: a float array that stores 16 sensor values
 *      Globals:
 *
 * Outputs:
 *      Returns: void
*/
void whack(int sensor_no, float * sensor_values)
{
    bool sensor_registered = false;
    int gnoll_sensor_indicator = 0;   // the order of sensor that gnoller's laser points to
    int whack_sensor_indicator = 0;   // the order of sensor that whacker's laser points to
    int gnoll_no = 0;
    int led_command = 0;              // led command to display the indicator LED in whacker
    int msec = 0;
    clock_t start;
    clock_t difference;

    if (sensor_no == 0) gnoll_no = 8;
    if (sensor_no == 8) gnoll_no = 0;

    // start timer for sensor reading
    start = clock();

    for (int i = 0; i < 15; i++) {
        pc.printf("i: %d\n", i);
        sensor_registered = false;
        
        // keep reading until one of the sensor get laser pointed in
        while (!sensor_registered) {
            // scan all 16 sensors into sensor_values array
            ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2);
    
            // scan all gnoll sensors
            for (int i = 0; i < TGT_SENSOR_QUAN; i++) {
                // detect which gnoll sensor get lasered on
                if (sensor_values[i + gnoll_no] * 3.3f > PTTHRESH) {
                    sensor_registered = true;
                    gnoll_sensor_indicator = i;
                    pc.printf("gnoll_sensor_indicator: %d\n", gnoll_sensor_indicator);
                }
            }
    
            // if (reading sensor timer expired) display error and freeze
            difference = clock() - start;
            msec = difference * 1000 / CLOCKS_PER_SEC;
            if (msec > WHACK_EXPIRED_TIMER) {
                pc.printf("Error: Reading timer expired. See whack() function.\n");
                while (1);
            }
        }
        
        pc.printf("stp_sensor_pos: %d\n", stp_sensor_pos[sensor_no + gnoll_sensor_indicator]);
        // point whack’s laser to the corresponding sensor on whack target array
        turn_to_target(stp_sensor_pos[sensor_no + gnoll_sensor_indicator]);
    
        // turn on whacker's laser
        lzr_on();
    
        start = clock();
        sensor_registered = false;
        
        // sense which sensor the whack laser point to and turn it on
        while (!sensor_registered) {    
            // scan all 16 sensors into sensor_values array
            ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2);
    
            for (int i = 0; i < TGT_SENSOR_QUAN; i++) {
                // detect which gnoll sensor get lasered on
                if (sensor_values[i + sensor_no] * 3.3f > PTTHRESH) {
                    sensor_registered = true;
                    whack_sensor_indicator = i;
                    pc.printf("whack_sensor_indicator: %d\n", whack_sensor_indicator);
                }
            }
    
            // if timer expire display error and freeze
            difference = clock() - start;
            msec = difference * 1000 / CLOCKS_PER_SEC;
            if (msec > WHACK_EXPIRED_TIMER) {
                pc.printf("Error: Reading timer expired. See whack() function.\n");
                while(1);
            }
        }
    
        // activate corresponding indicator in whack LED row
        led_command = 0x0500 + led_values[whack_sensor_indicator];
        pc.printf("led_command: %d\n", led_command);
        spi_send(as1107, led_command);
        wait(LED_DELAY);
    
        // waiting for gnoll laser to turn off to turn off
        do {
            // scan all 16 sensors into sensor_values array
            ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2);
        } while (sensor_values[gnoll_sensor_indicator + gnoll_no] * 3.3f > PTTHRESH);
    
        // turn off laer gnoll
        lzr_off();
        
        // turn off LED display
        spi_send(as1107, 0x0500);
    }
}

/*
 * void update_score(int hit, int miss)
 * Description: updates gnoller scoreboard
 *
 * Inputs:
 *      Parameters:
 *          int hit: whacker hit count
 *          int miss: whacker miss count
 *      Globals:
 *
 * Outputs:
 *      Returns: void
*/
void update_score(int hit, int miss)
{
    int d1, d2, d3, d4 = 0;
    if ( hit < 10)
        d1 = hit;
    else {
        d1 = hit % 10;
        d2 = (hit - d1)/10;
    }
    if ( miss < 10)
        d3 = miss;
    else {
        d3 = miss % 10;
        d4 = (miss - d3)/10;
    }
    pc.printf("d1: %d -- d3: %d\n", d1, d3);
    spi_send(as1107, 0x0100 + d1);
    spi_send(as1107, 0x0200 + d2);
    spi_send(as1107, 0x0300 + d3);
    spi_send(as1107, 0x0400 + d4);
}