/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: spi.h
* Purpose: Header for SPI driver
*
* Created: 03/01/2018
* Last Modified: 03/29/2018
*
******************************************************************************/

#ifndef SPI_H
#define SPI_H

#define SPI_NO_ID 0
#define SPI_AS1107_ID 1
#define AS1107_SPI_FREQ 1000000
#define AS1107_SPI_NO_BITS 16

#include "mbed.h"
#include "io_pins.h"

extern SPI wag_spi;

struct spi_cfg {
   int spi_id; //ID should be unique for each slave type
   DigitalOut spi_ncs; //The pin driving the slave's chip select
   int spi_mode; //SPI mode needed by this slave
   int spi_freq; //SPI frequency needed by this slave
   int spi_no_bits; //No. of data bits to be transfered each send to the slave 
};

void spi_send(struct spi_cfg spi_config, int spi_data);

#endif