/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: spi.cpp
* Purpose: Driver for SPI functions
*
* Created: 03/01/2018
* Last Modified: 03/29/2018
*
******************************************************************************/

#include "mbed.h"
#include "io_pins.h"
#include "spi.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

extern SPI wag_spi;

DigitalOut dsp_ncs(DSP_AS1107_NCS);//This sets up the chip select for the AS1107


extern struct spi_cfg as1107;


/*
 * void spi_send(struct spi_cfg spi_config, int spi_data);
 * Description: sends an instruction to an SPI device
 *
 * Inputs: 
 *      Parameters:
 *          struct spi_cfg spi_config: structure containing device qualities
            int spi_data: command to write to device
 *      Globals:
 *      
 * Outputs:
 *      Returns: void
*/
void spi_send(struct spi_cfg spi_config, int spi_data) {
    static int previous_id = SPI_NO_ID;
    spi_config.spi_ncs = 1;
    if (previous_id != spi_config.spi_id) {
        //send config data to master
        previous_id = spi_config.spi_id;
        wag_spi.frequency(spi_config.spi_freq);
        wag_spi.format(spi_config.spi_no_bits, 0);
    }
    spi_config.spi_ncs = 0;
    wag_spi.write(spi_data);
    spi_config.spi_ncs = 1;
}

