/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: main.cpp
* Purpose: Configures the dispaly for 4-digit display or motor control
*
* Created: 03/01/2018
* Last Modified: 04/06/2018
*
******************************************************************************/
#include "mbed.h"
#include "io_pins.h"
#include "display.h"
#include "spi.h"
#include "stepper.h"
#include "utility.h"
#include "analog.h"
#include "laser.h"
#include "wag.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

SPI wag_spi(MOSI, MISO, SCLK);
Serial pc(USBTX, USBRX);
DigitalIn jog_cw(UI_JOG_RIGHT_BUTTON);
DigitalIn jog_ccw(UI_JOG_LEFT_BUTTON);
DigitalIn my_button(USER_BUTTON);
DigitalIn start_button(UI_START_BUTTON);
DigitalIn cal_button(UI_CAL_BUTTON);
DigitalIn station_select(UI_STATION_SELECT);
DigitalIn home_sensor(STP_HOME_SENSOR);
DigitalOut laser(LZR_ENABLE);
AnalogIn mux_out (MUX_OUT);
BusOut mux_select(MUX_S0, MUX_S1, MUX_S2, MUX_S3);
int station = -1;
int cal_status = NOT_CALIBRATED;
float sensor_values[TGT_SENSOR_QUAN * 2];
int stp_sensor_pos[TGT_SENSOR_QUAN];

struct spi_cfg as1107{
    SPI_AS1107_ID,
    DSP_AS1107_NCS,
    SPI_NO_ID,
    AS1107_SPI_FREQ,
    AS1107_SPI_NO_BITS,
};


int main(void) {
    initial_setup(as1107);
    
    // pull up UI_STATION_SELECT
    station_select.mode(PullUp);
    start_button.mode(PullUp);
    
    //set all digits to zero
    spi_send(as1107, 0x0100);
    spi_send(as1107, 0x0200);
    spi_send(as1107, 0x0300);
    spi_send(as1107, 0x0400);

    pc.printf("Press user button to calibrate.\n");
    
    // determine if the wag is connected to station A or station B
    station = station_select.read();
    pc.printf("station in main: %d\n", station);
    
    stp_init();
    
    //calibration test
    stp_calibrate(station, sensor_values, &cal_status);
    
    //something went wrong with calibration, quit the program
    if (cal_status == NOT_CALIBRATED) {
        pc.printf("Critical error: station not calibrated.");
        while(1);
    }
    
    // play order
    if (station == STATION_A) {
        while (uti_chk_ubutton() == 0);
        gnoll(0, sensor_values);
        while (uti_chk_ubutton() == 0);
        whack(0, sensor_values);
    }
    else if (station == STATION_B) {
        while (uti_chk_ubutton() == 0);
        whack(8, sensor_values);
        while (uti_chk_ubutton() == 0);
        gnoll(8, sensor_values);
    }
    else {
        pc.printf("Critical error: no station detected.");
    }
} 