/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: main.cpp
* Purpose: Configures the dispaly for 4-digit display or motor control
*
* Created: 03/01/2018
* Last Modified: 04/06/2018
*
******************************************************************************/
#include "mbed.h"
#include "io_pins.h"
#include "display.h"
#include "spi.h"
#include "stepper.h"
#include "utility.h"
#include "analog.h"
#include "laser.h"
#include "wag.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

SPI wag_spi(MOSI, MISO, SCLK);
Serial pc(USBTX, USBRX);
DigitalIn jog_cw(UI_JOG_RIGHT_BUTTON);
DigitalIn jog_ccw(UI_JOG_LEFT_BUTTON);
DigitalIn my_button(USER_BUTTON);
DigitalIn start_button(UI_START_BUTTON);
DigitalIn cal_button(UI_CAL_BUTTON);
DigitalIn station_select(UI_STATION_SELECT);
DigitalIn home_sensor(STP_HOME_SENSOR);
DigitalOut laser(LZR_ENABLE);
AnalogIn mux_out (MUX_OUT);
BusOut mux_select(MUX_S0, MUX_S1, MUX_S2, MUX_S3);
int station = -1;
int cal_status = NOT_CALIBRATED;
float sensor_values[TGT_SENSOR_QUAN * 2];
int stp_sensor_pos[TGT_SENSOR_QUAN];

struct spi_cfg as1107{
    SPI_AS1107_ID,
    DSP_AS1107_NCS,
    SPI_NO_ID,
    AS1107_SPI_FREQ,
    AS1107_SPI_NO_BITS,
};


int main(void) {
    initial_setup(as1107);
    
    //set all digits to zero
    spi_send(as1107, 0x0100);
    spi_send(as1107, 0x0200);
    spi_send(as1107, 0x0300);
    spi_send(as1107, 0x0400);

    
    pc.printf("Press user button to test.\n");
    
    test_target_leds();
    pc.printf("LED's tested\n");
    
    test_phototransistors();
    pc.printf("Phototransistors tested\n");
    
    step_test();
    pc.printf("Step motor tested\n");
    
    pc.printf("laser test\n");
    while (my_button.read() == 0);
    pc.printf("test begin\n");
    lzr_init();
    wait(0.5);
    while (my_button.read() == 0) {
        lzr_on();
        wait(0.5);
        lzr_off();
        wait(0.5);
    }
    lzr_init();
    pc.printf("Laser tested.\n");
    
    // determine if the wag is connected to station A or station B
    station = station_select.read();
    pc.printf("station in main: %d\n", station);
    
    /** Part 9: calibration test **/
    pc.printf("Part 9: calibration test begin.\n");
    stp_calibrate(station, sensor_values, &cal_status);
    pc.printf("Part 9: calibration test done.\n");
    
    
    //stp_sensor_pos[0] = 27;
    //stp_sensor_pos[1] = 50;
    //stp_sensor_pos[2] = 72;
    //stp_sensor_pos[3] = 98;
    //stp_sensor_pos[4] = 122;
    //stp_sensor_pos[5] = 146;
    //stp_sensor_pos[6] = 173;
    //stp_sensor_pos[7] = 197;
        
    // turn on laser 
    lzr_on();
    
    /** Part 10: repeatibility test **/
    pc.printf("Part 10: press user button to begin the test.\n");
    while (uti_chk_ubutton() == 0);
    while (uti_chk_ubutton() == 0) {
        int sensor_no = 8;
        if (station == STATION_B) sensor_no = 0;
        
        // move to the left most sensor
        repeatability_test(0, cal_status);
        
        // read sensor value
        ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2);
        
        // print value 
        pc.printf("Sensor %d: %f\n", sensor_no, sensor_values[sensor_no] * 3.3f);
        
        // move to the right most sensor
        repeatability_test(TGT_SENSOR_QUAN - 1, cal_status);
        
        // read sensor value
        ana_scan_mux(sensor_values, TGT_SENSOR_QUAN * 2);
        
        // print value
        pc.printf("Sensor %d: %f\n", sensor_no + TGT_SENSOR_QUAN - 1, sensor_values[sensor_no + TGT_SENSOR_QUAN - 1] * 3.3f);
    }
    pc.printf("Part 10: repeatibility test done.\n");
} 