/******************************************************************************
* EECS 397
*
* Assignment Name: Lab 6: WaG
* 
* Authors: Sam Morrison and Phong Nguyen 
* File name: stepper.h
* Purpose: Header for stepper driver
*
* Created: 03/02/2018
* Last Modified: 03/29/2018
*
******************************************************************************/

#ifndef STEPPER_H
#define STEPPER_H

#define SPI_DRV8806_ID 2
#define DRV8806_SPI_NO_BITS 8
#define DRV8806_SPI_MODE 0
#define DRV8806_SPI_FREQ 1000000
#define STP_CW 0
#define STP_CCW 1
#define STP_POS_UNKN -5
#define TGT_SENSOR_QUAN 8
#define MOTOR_DELAY 0.003
#define TURN_DELAY 0.005


#include "mbed.h"
#include "io_pins.h"

void stp_init();
void stp_step(int direction);
void step_test();
void stp_find_home();
void stp_calibrate(int station, float * sensor_values, int * cal_status);
void repeatability_test(int sensor_position, int cal_status);

#endif 