#include "mbed.h"
#include "QEI.h"

class Encoder{
private:
    double pulses, wheelCircum;
    Ticker tkr;
    QEI encoder;
public:
    Encoder(PinName CHA, PinName CHB):encoder(CHA, CHB, NC, 624){    
        tkr.attach(callback(this, &Encoder::FindPulses), 0.01);
    }
    void FindPulses(){
        pulses = encoder.getPulses();
        tkr.attach(callback(this, &Encoder::FindPulses), 0.01);
    }
    double FindSpeed(){
        return pulses*wheelCircum;
    }
};

int main() {
    Encoder leftEncoder(PC_2, PC_1);
    Encoder rightEncoder(PC_15, PC_14);
    
    while(true){
        wait(1);
        leftEncoder.FindSpeed();
        rightEncoder.FindSpeed();
    }
}
