#include "mbed.h"
#include "DHT.h"
#include "MQ2.h"
#include "rtos.h"
#include "Servo.h"


 DigitalIn Occupant(D10);       //Hall Switch input shows to determine if vehicle is occupied
 DigitalIn EngSw(D3);           //Button D3 turns Engine on and off
 DigitalOut Buzz(D2);           //Alarm signaling high gas levels
 DigitalOut Engine(D9);         //Autoflash LED represents Engine running
 DigitalOut Red(PTC3);          //RED LED (RGB) D7
 DigitalOut Green(PTC2);        //GREEN LED (RGB) D6
 DigitalOut Blue(PTA2);         //BLUE LED (RGB) D5
 DigitalOut Heat(LED1);         //Red on-board LED 
 DigitalOut AC(LED3);           //Blue on-board LED
 DigitalOut led2(LED2);         //Green on-board LED 
 DHT sensor(D4, DHT11);         //Temperature and humidity sensor
 PwmOut PWM1(D11);               //pin A4 == pin A5
 Serial pc(USBTX, USBRX);       
 MQ2 mq2(A1);                   // Analog Port to read from MQ2_gas sensor
 Servo myservo(A5);             //Servo signal to simulate a window opening or closing
 InterruptIn sw2(SW2);          //Switch used to manually switch between AC/Heater setting(led color)
 InterruptIn sw3(SW3);          //Switch used to manually open or close the window
   float p = 0; 
   float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f; 
   int x = 1;
   int win = 0;  
   int fan = 0;                /*DC motor signal*/


int main() {
        myservo = p;
        pc.baud(115200);
        mq2.begin();                                                           // 'Calibrate' sensor
        MQ2_data_t MQ2_data;                                                        // Structure to hold data.
        sensor.readData();
        Engine = 0;
        Heat = 1;
        AC = 1;
        led2 = 1;
        int on = 1, off = 0;
        int open = 1, closed = 0;
        Buzz = !off;
        win = closed;
        PWM1.period_ms(500);
        PWM1.pulsewidth_ms(fan);
  
while (true) 
    {           mq2.read(&MQ2_data);
                PWM1.period_ms(500);
                PWM1.pulsewidth_ms(fan);
                int error = 0;               //Thread::wait(250);
                error = sensor.readData();
                                if (0 == error) {
                                    c   = sensor.ReadTemperature(CELCIUS);
                                    f   = sensor.ReadTemperature(FARENHEIT);
                                    k   = sensor.ReadTemperature(KELVIN);
                                    h   = sensor.ReadHumidity();
                                    dp  = sensor.CalcdewPoint(c, h);
                                    dpf = sensor.CalcdewPointFast(c, h);
                                    pc.printf("Temperature in Celcius: %4.2f\r\nTemperature in Farenheit: %4.2f\r\n", c, f);
                                    //printf("Temperature in Kelvin: %4.2f,\r\nCelcius: %4.2f,\r\n Farenheit %4.2f\r\n", k, c, f);
                                    //printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
                                }
                                 else {
                                    pc.printf("Temperature in Celcius: %4.2f\r\nTemperature in Farenheit: %4.2f\r\n", c, f);    //pc.printf("Error: %d\n", error);
                                }
                                         //pc.printf("................................\r\n");                      
                                //mq2.read(&MQ2_data);                                                     // Alt reading method, reading to structure
                                pc.printf("CO PPM: %.0f\r\n",MQ2_data.co);                              // Return data from structure
                                //pc.printf("Smoke PPM: %.0f\r\n",MQ2_data.smoke);                        // Return data from structure
                                //pc.printf("LPG PPM: %.0f\r\n",MQ2_data.lpg);                            // Return data from structure
                                pc.printf("................................\r\n");                      
                                // wait(.1);
                   if(EngSw == 0) {
                        if(Engine == off){
                        Engine = on;}
                        else{
                        Engine = off;
                        AC = !off;
                        Heat = !off;
                        }
                    }           
                   if((sw2 == 0) && (win == closed)){
                                                    //for(; p<1.0 && sw2 == 0; p += 0.05) {          //**Servo simulates opening a window if CarbonMonoxide level inside becomes too high while occupant is present 
                                                    while(p<=1.0 && sw2 ==0){
                                                    p=p+0.05;    
                                                    myservo = p;
                                                    wait(0.05);
                                                    }
                                                win = open;
                                                }
                   else if((win == open) && (sw2 == 0)){
                                                    //for(; p>0 && sw2 ==0; p -= 0.05) {
                                                    while(p>=0.0 && sw2 ==0){
                                                    p=p-0.05;
                                                    myservo = p;
                                                    wait(0.05);
                                                    }
                                                win = closed;
                                                } 
                   if(sw3 == 0 && Engine == on){                                  //***If switch3 is pressed 
                                if(AC == !on)    
                                { Heat = !on;AC = !off;}
                                else if(Heat == !on)  
                                {Heat=!off;AC=!off;
                                  fan=off;  }
                                else 
                                AC = !on;
                              } 
                         if(Heat == !on || AC == !on) {  
                             fan = 10;}
                         else if(Heat == !off && AC == !off){
                             fan = off;}           
                   if(Occupant == 1){  
                         Red = 0;                  //   
                         Blue = 0;                 //(r,g,b) = (0,0,0) = white
                         Green = 0;
                         Buzz = !off; }                // 
                  else if(Occupant == 0)
                     {          
                             if(MQ2_data.co>=300)
                                {              // wait(.5);                  //
                                 Red = 0;                  //
                                 Blue = 1;                 //(r,g,b) = (0,1,1) = red
                                 Green = 1;                //
                                 Buzz = !on; 
                                 if(win == closed){
                                                    //for(; p<1.0; p += 0.05) {          //**Servo simulates opening a window if CarbonMonoxide level inside becomes too high while occupant is present 
                                                    while(p<=1.0){
                                                    p=p+0.05;
                                                    myservo = p;
                                                    wait(0.05);
                                                    }
                                                win = open;
                                                }
                                     // if(win == open && Engine == on){
                                       //   Engine = off;}           
                                 }                  //
                             else if(MQ2_data.co >=50 && MQ2_data.co <= 300)
                                 {    //wait(.5);                  //
                                 Buzz = !off;
                                 Blue = 1;                 //(r,g,b) = (0,0,1) = yellow
                                 Green = 0;                //
                                 Red = 0;                  //
                                 }//wait(.5);                 //**RGB end**
                             else{
                                  Red = 1;                  //   
                                  Blue = 1;                 //(r,g,b) = (1,1,0) = green
                                  Green = 0;
                                  Buzz = !off;
                             }
                            if(f >= 90 || f <= 50)        //Temperature from DHT 
                             {          Engine = on;                  //x = 10;
                                        fan = 10;
                                        if(f>=90){ 
                                                AC = !on;Heat=!off;
                                                if(win == closed){                      //**Servo simulates opening a window if Temperature inside becomes too high while occupant is present 
                                                    //for(; p<1.0; p += 0.05) {
                                                    while(p<=1.0){
                                                    p=p+0.05;
                                                    myservo = p;
                                                    wait(0.05);
                                                    }
                                                win = open;
                                                }
                                        else if(f<=50)
                                            {       Heat = !on;AC=!off;  
                                                    if(win == open){
                                                            //for(; p>0.0; p -= 0.05) {
                                                            while(p>=0.0){
                                                            p=p-0.05;
                                                            myservo = p;
                                                            wait(0.05);
                                                            }
                                                    win = closed;
                                                 }       
                                            }                      
                                      }
                                } 
                           /* else if(Occupant == 0 && AC == !on){
                                         Engine = on;                  //x = 10;
                                       fan= 4;
                                    } 
                            else if(Occupant == 0 && Heat == !on){
                                         Engine = on;                  //x = 10;
                                       fan=4;
                                  }  */
        }
    } 
}
