#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
//use for cin
#include <iostream>
//Clock class is a class for time and date
#include "Clock.h"
//Reading class is for each reading, date and time (Clock), temperature, pressure and humidity 
#include "Reading.h"
//#include "string.h" //do we need this to use a string? where is it in classes?

DigitalOut myled(LED1);
I2C i2c2(I2C_SDA, I2C_SCL);

float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100; 
char cmd=0;
uint32_t seconds = 0, minutes=0, hours=0; 
Ticker timer;
Clock *clockDT = new Clock(); //DT stands for Date Time, this stores the 'current' time of the system. operated by ticker. Note: install ticker


LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);


//void thread1( const void* );
Thread *t1;
Thread *t2;
Thread *t3;

    
Mail<Reading,16> mail_box;

//Queue<Reading,16> queue;
void pingMeasure(){
    //ping the measure()
    t2->signal_set(8);
    }    
void measure() {
    
    //Thread waits for the ping from pingMeasure
    Thread::signal_wait(8);
    
    Reading *reading = mail_box.alloc();
    if (reading == NULL) {
        printf("reading=null");
        return;
        }
    
     reading->clock.setClock(clockDT);
     humidity.ReadTempHumi(&tempCelsius, &humi);
     reading->temp = tempCelsius;
     reading->humidity = humi;
     barometer.get();
     reading->pressure = barometer.pressure();
     //printf("winner winner chicken dinner");
    
    osStatus stat = mail_box.put(reading);
    
    if (stat == osErrorResource) { 
        printf("queue->put() Error code: %4Xh, Resource not available\r\n", stat);   
        mail_box.free(reading);
        return;
    }
}
void commands(){
    float f1 =0;
    int i1 =0;
    int i2 =0;
    int i3 =0;
    char s1 [10];
    char s2 [10];
    char s3 [10];
    char s4 [10];
    char line [150];
    
    while(1) {
      cin.getline( line, 100, '\n' );
      scanf("%s %s %s %s",line);
      //i1 = std::stoi( s2);
      printf("s1 is %s0   s2 is %s    s3 is %s \n",s1,s2,s3);


        //USE STRNCMP INSTEAD : (strncmp (str[n],"R2xx",2) == 0) WHERE str[n] and "R2xx" are strings to compare and 2 is an int of characters to check
      if(s1=="?"){
        printf("SOFT253 simple Temperature Humidity and Pressure Sensor Monitor\n\r");
        printf("Using the X-NUCLEO-IKS01A1 shield and MBED Libraries\n\r");
      }
      if(s1=="A"){//Gives a reading on command
      printf("A was entered");
      
        //humidity.ReadTempHumi(&tempCelsius, &humi);
        //printf("%4.2fC %3.1f%%", tempCelsius, humi);
        //barometer.get();
        //printf(" %6.1f %4.1f\r\n", barometer.pressure(), barometer.temperature());
        //myled = 1; // LED is ON
        //Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds! 
        //myled = 0; // LED is OFF
        //Thread::wait(100); // 100 ms
      }
      //readers
      if(s1 =="READ"){//reads all records Sends a comma separated list of all measurements. Each record shall be separated with a \n newline. Each record shall be comma separated as follows: date, time, temperature, pressure, humidity
          if (s2 == "ALL"){
              //READ ALL 
          }
          else if (i1>0){
              //READ <n> n is i1
          }
          else{
              printf("Are you trying to read something? try READ ALL or READ <n>");
          }
      }
      //deleters
      else if(s1=="DELETE"){//deletes all records  The F401 will return a string �DELETED <N> RECORDS� N = no. deleted obviously
        if (s2 =="ALL"){
            //delete all
        }
        else if (i1>0){
            //delete <n> //Delete the oldest <n> records.return �DELETED <m> RECORDS� m is how many were deleted obviously
        }
        else{
            printf("Are you trying to delete something? Try DELETE ALL or DELETE <n>");
        }
      }
        
     
      
      if(s1=="SETDATE"){//  no points for guessing what this one does. return a string �DATE UPDATED TO <dd> <dd> <yyyy>�
      
      }
      if(s1=="SETTIME"){//  nil point. return �TIME UPDATED TO <hh> <mm> <ss>�
       
      }
      if(s1 == "SETT"){// SETT <t> set sampling rate to 0.1=T=60.0  return a string �T UPDATED TO <T>� otherwise return an �OUT OF RANGE� error.
          //f1 =  std::stof( s2 );

      }
      if(s1=="STATE"){//STATE <x> set sampling ON or OFF
        if(s2=="ON"){
            //turn sampling on. somehting like timer.attach
        }
        else if(s2=="OFF"){
            //turn sampling off. somehting like timer.detach
        }
      
      }
      if(s1=="LOGGING"){// turns on/off diagnostic logging to the serial interface. The F401 will return a string �LOGGING <x>�
        if(s2=="ON"){
            //turn logging on. 
        }
        else if(s2=="OFF"){
            //turn logging off. 
        }

      
      }
        
    }
    }
void thread1()
{
        while (true) {
        osEvent evt = mail_box.get();
        //Check status
        if (evt.status == osEventMessage) {
            Reading *pReading = (Reading*)evt.value.p;  //This is the pointer (address)
            //Make a copy
            Reading msg(pReading->clock ,pReading->temp, pReading->humidity, pReading->pressure);//CHECKVARIABLE NAMES
            //We are done with this, so give back the memory to the pool
            mail_box.free(pReading);
            
           
        }//add it to the queue!!!!
    }
}

// main() runs in its own thread in the OS
int main() {
        //show a sign of life
        //myled = 1;
        humidity.init();
        humidity.calib();
        printf("SOFT253 simple Temperature Humidity and Pressure Sensor Monitor\n\r");
        //printf("Using the X-NUCLEO-IKS01A1 shield and MBED Libraries\n\r");
        //tickevey 15seconds to measure environment
        
        timer.detach();
        timer.attach( &pingMeasure, 15);
        printf("well something should be happening right baout now");
        t1 = new Thread();
        t1->start(thread1);
        t2 = new Thread();
        t2->start(measure);
        t3 = new Thread();
        t3->start(commands);
        
        printf("Threads Started\n\r");
        
        while (true){
        Thread:: wait(5000);
        }
}