#include "mbed.h"
#include "QEI.h"
#include <cmath>

#define SERIAL_BAUD 115200

Serial pc(USBTX,USBRX);

DigitalOut dirpin(D4);
PwmOut pwmpin(D5);
AnalogIn pot_1(A1);
DigitalOut dirpin_2(D7);
PwmOut pwmpin_2(D6);
AnalogIn pot_2(A2);

QEI Encoder1(D13,D12,NC,64,QEI::X4_ENCODING); //X4 encoding
QEI Encoder2(D11,D10,NC,64,QEI::X4_ENCODING); //X4 encoding

// motor1 is motor voor translatie
// motor2 is motor voor rotatie

double pwmperiod = 0.00006; // period of pwm, in seconds
double delta_t = 17*pwmperiod; // time to make calculations
const double pi = 3.14159265358979323846; // constant pi
volatile double positie_x; // desired change in x-direction, given by EMG or potmeter
volatile double positie_y; // desired change in y-direction, given by EMG or potmeter
volatile double delta_y; // change in y direction, due to change in x direction
volatile double delta_x; // change in x direction, due to change in y direction
volatile double dc2_x; // desired change in counts2 for x-direction
volatile double dc1_x; // desired change in counts1 for x-direction
volatile double dc2_y; // desired change in counts2 for y-direction
volatile double dc1_y; // desired change in counts1 for y-direction
volatile double A; // position of the pen with respect to the middle
volatile double counts_per_round = 8400;
volatile double gamma = (2*pi)/(25*counts_per_round); // distance traveled per count by big gear
volatile double Lpc_x; // position in x-direction of pen with respect to the middle
volatile double Lpc_y; // position in x-direction of pen with respect to the middle
volatile double theta; // total angle traveled
const double r = 185; // (mm) radius inner circle
const double alpha = (2*pi)/counts_per_round; // distance traveled by penholder per count 
const double l_beta = 32.5; // distance (mm) that the pen is away from the tower, due to limitations
volatile double counts1;
volatile double counts2;
volatile double speed_desired_motor2; // desired speed of motor2
volatile double speed_desired_motor1; // desired speed of motor1
volatile double max_speed_motor2; //


// functions
// -----------------------------------------------------------------------------
void potmeter(float& a, float& b)
{
    // Potmeter 1
    float out_1 = a;
    a = (out_1*2.0f) - 1.0f;
    pc.printf("out_2 = %f ", a); // + or - x-direction  
 
    // Potmeter 2   
    float out_3 = b;
    b = (out_3*2.0f) - 1.0f;
    pc.printf("out_4 = %f ", b); // + or - y-direction
    }

void encoder(volatile double& a, volatile double&b)
{
    a = Encoder1.getPulses();
    b = Encoder2.getPulses();
    pc.printf("counts1=%i counts2=%i ", counts1,counts2);
    }
    
void direction_prep(volatile double& a, volatile double& b, volatile double& c, volatile double& d) // a=positie_x, b=positie_y, c=theta, d=A
{
    // verwerking potmeter output tot richtingen motor
    a = pot_1*20.0*delta_t; // de max is 20 mm/s
    b = pot_2*20.0*delta_t;
    c = gamma*counts2;
    Lpc_x = (r-(alpha*counts1+l_beta))*sin(c);
    Lpc_y = (r-(alpha*counts1+l_beta))*cos(c);
    d = sqrt(pow(Lpc_x,2)+pow(Lpc_y,2));
    
    pc.printf("positie_x=%f positie_y=%f ",positie_x,positie_y);
    }
    
void x_direction(volatile double& a, volatile double& b) // a=dc2_x, b=dc1_x
{
    a = (asin(positie_x/A)/gamma)-counts2;
    delta_y = A*cos(gamma*dc2_x+theta);
    b = (r-(delta_y/cos(theta))-l_beta)/alpha;
    
    pc.printf("dc2_x=%f dc1_x=%f ",dc2_x,dc1_x);
    }
    
void y_direction(volatile double& a, volatile double& b) // a=dc2_y, b=dc1_y
{ 
    a = (acos(positie_y/A)/gamma)-counts2;
    delta_x = A*sin(gamma*dc2_y+theta);
    b = (r-(delta_x/cos(theta))-l_beta)/alpha;
    
    pc.printf("dc2_y=%f dc1_y=%f ",dc2_y,dc1_y);
    }

void counts_to_pwm()
{
    // going from counts to pwm
    speed_desired_motor1 = ((dc1_x+dc1_y)*alpha)/delta_t; // for max 2cm/s translation -> range pwm: -1/pi - 1/pi
    speed_desired_motor2 = ((dc2_x+dc2_y)*gamma)/delta_t; // for max rotation -> range pwm: -2/4,65 - 2/4,65
    max_speed_motor2 = 46.5; // CALCULATIONS NEEDED!!!
    
    pc.printf("speed1=%f speed2=%f ", speed_desired_motor1,speed_desired_motor2);
    
    double pwm1 = speed_desired_motor1/(pi); // 20.0 mm/s
    double pwm2 = (speed_desired_motor2*2)/(max_speed_motor2);
    
    pc.printf("pwm1=%f pwm2=%f\r\n",pwm1,pwm2);    
        
    // giving directions to motors
    dirpin.write(pwm2 < 0);  
    pwmpin = fabs (pwm2);
    dirpin_2.write(pwm1 < 0);
    pwmpin_2 = fabs (pwm1);
    }
    
void rki_big_function()
{
    float a = pot_1;
    float b = pot_2;
    potmeter(a,b); // zet potmeter waarden om naar goede range (-1 - 1)
    encoder(counts1,counts2); // getting counts from encoder 
    direction_prep(positie_x, positie_y, theta, A); // a=positie_x, b=positie_y, c=theta, d=A   
    x_direction(dc2_x,dc1_x); // counts for change in x-direction
    y_direction(dc2_y,dc1_y); // counts for change in y-direction       
    counts_to_pwm(); // changing counts to pwm
    }


// main
// -----------------------------------------------------------------------------
int main()
{   
    pc.baud(115200); // setting baudrate 
    pc.printf("start\r\n"); // to see if the program starts 
    pwmpin.period_us(60); // setting the pwm period
    
    while(true)
    {
        rki_big_function();
 
        wait(delta_t); // aantal keer dat een signaal wordt gecheckt en doorgestuurd    
        } 
}

