#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"

//definitions and pin allocations
HIDScope scope(2); // We’re going to send 2 channels of data
Ticker AInTicker;
//AnalogIn aIn1(A0);
DigitalOut dirpin(D4);
PwmOut pwmpin(D5);
QEI Encoder(D12,D13,NC,64,QEI::X4_ENCODING);    //channel A=D12, channel B=D13
AnalogIn pot1(A1);
AnalogIn pot2(A2);

//volatile variable definitions
volatile float x;
volatile float x_prev =0; 
volatile float y; // filtered 'output' of ReadAnalogInAndFilter 


//functions
int counts(){
    int counts=Encoder.getPulses();
    return counts;}

float out1(){
    float out_1 = (pot1 * 2.0f) - 1.0f;        //scales potmeter signal from 0 to 1 into -1 to 1
    return out_1;}
    
int out2(){
    float out_1 = (pot2 * 2.0f) - 1.0f;        //scales potmeter signal from 0 to 1 into -1 to 1
    if (out_1<-0.25){
        return 0;}
        
    else if ((out_1>-0.25)&&(out_1<0.25)){
        return 1;}
    
    else {
        return 2;}
    }

void motor_pos1(){
        dirpin.write(0);                        
        pwmpin = 1.0f;}                         

void motor_neg1(){
        dirpin.write(1);                        
        pwmpin = 1.0f;}
        
void motor_pot(){
        dirpin.write((out1())<0);                        
        pwmpin = fabs(out1());}
        
void ReadAnalogInAndFilter(){
        x = counts();   // Capture data        
        scope.set(0, x);   // store data in first element of scope memory
        y = (x-x_prev)/0.001f;   // averaging filter
        scope.set(1, y);  // store data in second element of scope memory
        x_prev = x; // Prepare for next round
        scope.send();} // send what's in scope memory to PC




//main function
int main(){
        pwmpin.period_us(60);
        
        //HIDScope timer attach
        AInTicker.attach(&ReadAnalogInAndFilter, 0.01);
        
        //Motor control
        while (true) {
            switch(out2()){
                case 0:
                    motor_pos1();
                    break;
                case 1:
                    motor_neg1();
                    break;
                case 2:
                    motor_pot();
                    break;}
            wait(0.1);}
}
