#include "mbed.h"
#include "MRF24J40.h"
#include <string>
#include "packet.h"

//define a node number
#define NODE 2

// RF tranceiver to link with gateway.
MRF24J40 mrf(p11, p12, p13, p14, p21);

// LEDs you can treat these as variables (led2 = 1 will turn led2 on!)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Timer
Timer timer;

// Serial port for showing RX data.
Serial pc(USBTX, USBRX);

// Used for sending and receiving
//char txBuffer[128];
//char rxBuffer[128];
int rxLen;
packet* txBuffer;
packet* rxBuffer;

//***************** Do not change these methods (please) *****************//

/**
* Receive data from the MRF24J40.
*
* @param data A pointer to a char array to hold the data
* @param maxLength The max amount of data to read.
*/
int rf_receive(packet *data, uint8_t maxLength, uint8_t *rssi)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength, rssi);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};

    if(len > 10) {
        pc.printf("got data\r\n");
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(((uint8_t *)data)[i] != header[i])
                    return 0;
            } else {
                ((uint8_t *)data)[i-8] = ((uint8_t *)data)[i];
            }
        }
        len = len - 8;
    }
    if(len > 4) {
        //valid data with full header
        if(data->to != NODE)
        {
            //throw out the data
            return 0;
        }
        pc.printf("Received data for us from node: %d TTL: %d\r\n",data->from,data->TTL);
        
        switch(data->TYPE)
        {
            case HELLO_TYPE:
            pc.printf("HELLO\r\n");
        }            
            
        //pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    
    
    return ((int)len);
}

/**
* Send data to another MRF24J40.
*
* @param data The string to send
* @param maxLength The length of the data to send.
*                  If you are sending a null-terminated string you can pass strlen(data)+1
*/
void rf_send(packet *data, uint8_t len)
{

    data->from = NODE;
    

    mrf.Send((uint8_t *) data, (len*4)+4);
}


//***************** You can start coding here *****************//

int main (void)
{
    //Set the channel of the slave
    uint8_t channel = 15;
    mrf.SetChannel(channel);
    
    //Analog input
    AnalogIn light(p20);   //Analog input from the light sensor 
    AnalogIn temp(p19);     //Analog input from the temp snesor
    
    //Variable to read values
    float val = 1;
    int begin = 0;
    int end = 0;
    int current = 0;
    uint8_t *rssi;
    
    //Start the timer
    timer.start();  

    while(true) { 
        
        //Try to receive some data
        rxLen = rf_receive(rxBuffer, 128, rssi);
        
        if(rxLen > 0) {

            //Switch on the Led and start the timer
            printf("Received input\n");
            led1 = 1;
            begin = timer.read_ms();
            end = begin + 1000;
            //strcpy(txBuffer, "n");


            while(current < end) {

                current = timer.read_ms();
  //              val = button.read();
//                //printf("val: %f\r\n",val);
//                if(val < 0.1f ) {
//                    strcpy(txBuffer, "y"); ///send "y" if press
//                    break;
//                }

            }//end of 1 sec while loop

            led1 = 0; //Switch of the Led
//            rf_send(txBuffer, strlen(txBuffer) + 1); // send data
            pc.printf("Sent: %s\r\n", txBuffer);

        }//end of if loop



    }// end of while true

}//end of main