/**************************************************************
/ ME31001 Group: 1-04
/
/ Final Project
/
/ The program controls the operation of a ball launcher that fires a
 ball in a random direction and changes distance fired based on how long
 it took ball to be returned
/**************************************************************/

#include "mbed.h"
#include "Servo.h"
#include "stdlib.h"
#include "time.h"


PwmOut FMotor(p23); // set the firing motors as an output
Servo myservo1 (p22); // servo to rotate the base 
Servo myservo2 (p21); // servo to release the ball

DigitalIn PB(p17);  // a push button that when switched turns on the program and when switched again turns it off
DigitalIn LDR(p19); // An LDR sensor to check if the ball is in the right position 

Timer t; // we need a timer to see how long it has been since the ball was in the chute

int main() {
  
  int x = 0; // a counter to check if the push button switch has been pressed
  
    while(1) {
  
        if (PB.read() == 1) //if the pushbutton is pressed then we change the variable x
        {
            x = !x;
            wait (0.25);
            }
            
            
        if (PB.read() == 0 && x == 0) // if the pushbutton is not currently pressed and x is in the 0 state run the rest of the program
         {
            if (LDR) {  // if the ball is in position
                FMotor.period(0.010); // set PWM period to 10 ms
                FMotor = 0.5; // start the motors at 50% duty cycle
                
             int r = rand() % 50; // make r be a random number between 1 and 50
                
                
                 for(float p=0; p<1.0 && r != 35; p += 0.05) {    // if r is 35 (could be any number) then the servo will stop turning otherwise it sweeps through its full range
                    myservo1 = p;
                    int r = rand() % 50;
                       wait(0.2); }
                
                for(float p=1; p>0 && r != 35; p -= 0.05) { 
                         myservo1 = p;
                   int r = rand() % 50;
                         wait(0.2);
        }
            
              for(float q=0; q<0.5; q += 0.05) {   // remove the lever holding the ball up
                 myservo2 = q;
                wait(0.2); }
        
                wait (1);
                
                for(float q=0.5; q>0; q -= 0.05) {  // put the leaver back into place
                 myservo2 = q;
                 wait(0.2); }
         
                wait (3); // give time for the ball to fire
                t.start(); // start the timer
                FMotor = 0; // turn off motors
                
                }
           do   // create a new loop so that the program doesn't keep on repeating the first part 
           {     
                
        if (LDR) {  // see if the ball is back in position in position    
                t.stop(); // stop the timer to see how long it took the ball to get back
                }
                
            if (LDR && t.read() <5) {   // if the ball in back in position and it took less than 5 seconds for the ball to get back
                FMotor.period(0.010); // set PWM period to 10 ms
                FMotor = 1; // start the motors at 100% duty cycle
                
             int r = rand() % 50; // make r be a random number between 1 and 50
                
                
                   for(float p=0; p<1.0 && r != 35; p += 0.05) {    // if r is 35 (could be any number) then the servo will stop turning otherwise it sweeps through its full range
                    myservo1 = p;
                    int r = rand() % 50;
                       wait(0.2); }
                
                for(float p=1; p>0 && r != 35; p -= 0.05) { 
                         myservo1 = p;
                   int r = rand() % 50;
                         wait(0.2);
        }
            for(float q=0; q<0.5; q += 0.05) {   // remove the lever holding the ball up
                 myservo2 = q;
                wait(0.2); }
        
                wait (1);
                
                for(float q=0.5; q>0; q -= 0.05) {  // put the leaver back into place
                 myservo2 = q;
                 wait(0.2); }
                 
                wait (3); // give time for the ball to fire
                t.start(); // start the timer
                FMotor = 0; // turn off motors
                
        
     if (LDR) {  // see if the ball is back in position in position    
                t.stop(); // stop the timer to see how long it took the ball to get back
                }
          }
          if (LDR && t.read() >5) {   // if the ball in back in position and it took less than 5 seconds for the ball to get back
                FMotor.period(0.010); // set PWM period to 10 ms
                FMotor = 0.25; // start the motors at 25% duty cycle
                
             int r = rand() % 50; // make r be a random number between 1 and 50
                
                
                  for(float p=0; p<1.0 && r != 35; p += 0.05) {    // if r is 35 (could be any number) then the servo will stop turning otherwise it sweeps through its full range
                    myservo1 = p;
                    int r = rand() % 50;
                       wait(0.2); }
                
                for(float p=1; p>0 && r != 35; p -= 0.05) { 
                         myservo1 = p;
                   int r = rand() % 50;
                         wait(0.2);
        }
            
                for(float q=0; q<0.5; q += 0.05) {   // remove the lever holding the ball up
                 myservo2 = q;
                wait(0.2); }
        
                wait (1);
                
                for(float q=0.5; q>0; q -= 0.05) {  // put the leaver back into place
                 myservo2 = q;
                 wait(0.2); }
                 
                wait (3); // give time for the ball to fire
                t.start(); // start the timer
                FMotor = 0; // turn off motors
                }    
            }
        while ( x == 0);
        }
    }
  
}
