#include "mbed.h"
#include <string>
using std::string;
#include "bq79606.h"

#define BaudR125k       0x303C
#define BaudR250k       0x343C
#define BaudR500k       0x383C
#define BaudR1M         0x3C3C

DigitalIn bmsLVFault(PB_4);
DigitalOut bmsLVWakeUp(PB_5);

Serial pc(PA_0, PA_1, 250000);//PA_9, PA_10,250000);
Serial pc1(USBTX, USBRX, 9600);//PC_10, PC_11,9600);
bool full = false;
int expected = 0;
int bLen = 0;
int rdLen = 0;
uint8_t response_frame[(MAXBYTES+6)*TOTALBOARDS];

void WakeUp() {
    bmsLVWakeUp=0;//active low
    wait_us(250);//wait min 250us
    bmsLVWakeUp=1;//de-assert, done with toggle in code example
    wait_ms(7);  //tsu(wake) 7ms delay PER BOARD before beginning communication  
}


void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc1.printf("* * *    Uspesan PRIJEM!     * * *\n");
    while(pc.readable()){
        pc1.printf("jepse");
        pc1.printf("%d\n", pc.getc());
        bBuf[bLen++]=pc.getc();
        if(expected==0) expected = bBuf[0]+4;
        if(expected==bLen){
            full=true;
            rdLen=expected;
            expected=0;
            bLen=0;
        }
    }
}
void waitFrame(){
    while(!full);
    full=false;
    for(int i = 0;i<rdLen;i++){
        pc1.printf("%X ",bBuf[i]);
    }
    
    pc1.printf("\n\n- - - VOLTAGE - - -\n");
    for(int i = 1; i < bBuf[0] - 1; i += 2){
        int voltage = bBuf[i+1];
        voltage |= (bBuf[i]) << 8;
        double vol = ((double)voltage)/65536.0 * 5.0;
        pc1.printf("CELL[%d] = %.6f V\n",(bBuf[0] - 1)/2 -(i-1)/2,vol);
    }
      
    pc1.printf("\n");
}

int main() 
{
   bmsLVWakeUp = 1; //po defaultu je HIGHT

   BYTE  wTemp = 0;
   pc.attach(&callback);
   
   pc1.printf("INICIJALIZACIJA START \n");
   WakeUp();
   //clearing faults after wake up is recommended
   
   //!!!! CLEAR FAULTS !!!
   
   CommReset(); 

   //set 250K baud to BMS first board
   
   sciSetBaudrate(scilinREG, BaudR250k);
   
   WriteReg(0,COMM_CTRL, BaudR250k ,2, FRMWRT_ALL_NR);//setting the baud rate to device

   WriteReg(0,ECC_TEST,0x00,1, FRMWRT_ALL_NR); //dummy write to the ECC_TESTregisterto syncthe DLL 
   
   WriteReg(0,CONFIG,0x00,1, FRMWRT_ALL_NR);//making sure auto-address mode is set on all devices(and NOT GPIO address mode)
   
   WriteReg(0,CONTROL1,0x01,1, FRMWRT_ALL_NR);//enabling and entering auto-addressing mode on the devices by setting the CONTROL1 register
   
   WriteReg(0,CONFIG, 0x01 ,1, FRMWRT_SGL_NR);//If there is only one device,you can instead do one command to assign the device as both the base AND top of stack(set CONFIG to 0x01)
   
   waitFrame();
      //COMM_TO DISABLED 
   WriteReg(0, COMM_TO, 0x00, 1, FRMWRT_ALL_NR);//noT(Setting Communications Timeout (10 minute short communication timeout, sleep mode on long communication timeout, long timeout length of 30 minutes))
   WriteReg(0, TX_HOLD_OFF, 0x00, 1, FRMWRT_ALL_NR);//Communications transmit delay set to zero
   
   //masking all low level faults (zakomentovacemo ono sto nam ne treba)
   
    WriteReg(0, SYSFLT1_FLT_RST, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //reset system faults
    WriteReg(0, SYSFLT1_FLT_MSK, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //mask system faults (so we can test boards and not worry about triggering these faults accidentally)
   
   //MASKING_END
   
   pc1.printf("INICIJALIZACIJA END \n");
   
   pc1.printf("Response? \n");
   // read device ID to see if there is a response
   ReadReg(0, 10, &wTemp, 1, 0,FRMWRT_SGL_R );
   wait_ms(10);
   wait(1);

   //----------------------
   WriteReg(0, CONTROL2, 0x00, 1, FRMWRT_ALL_NR);//Set OVUV_EN=0 before changing settings
   
   WriteReg(0, 0x29, 0x3F, 1, FRMWRT_ALL_NR);//enabling over voltage under voltage for all 6? cell channels
   WriteReg(0, 0x2A, 0x53, 1, FRMWRT_ALL_NR);//set cell UV to 2.8 V
   WriteReg(0, 0x2B, 0x5B, 1, FRMWRT_ALL_NR);// set cell OV to 4.3V
   
   WriteReg(0, CONTROL2, 0x04, 1, FRMWRT_ALL_NR);//OVUV_EN=1
   //---------------------- 
   
   WriteReg(0, 0x28, 0x3F, 1, FRMWRT_ALL_NR);//configure GPIO as AUX voltage(absolute voltage INSTEAD OF RATIOMETRIC) if necessary
   
   WriteReg(0, 0x27, 0x00, 1, FRMWRT_SGL_NR);//modifying the ADC delay of each device individually, since there is only one...modify device 0 delay
   
   WriteReg(0, 0x26, 0x08, 1, FRMWRT_ALL_NR);//AUX sample rate 1 MHz,128 decimation ratio
    //Konsultuj se s DJalom da bi smo odredili sample i low pass filter koji je on stavio na ploci
   WriteReg(0, 0x24, 0x23, 1, FRMWRT_ALL_NR);//1 MHz sample rate,64 decimation ratio,19.7Hz LPF
   /* ????Odnosi se na DIETEMP pitati Djaleta
   WriteReg(0, 0x25, 0x02, 1, FRMWRT_ALL_NR);//5 ms conversion interval if continuous conversion enabled
   */

   WriteReg(0, 0x109, 0x3F, 1, FRMWRT_ALL_NR);// enables ADC for all 6 cell channels
   wait_ms(5);// ensure proper settling time for best accuracy
   
  // ODLUCILE SMO SE ZA CONTINUOUS READ
   //WHICHEVER WE NEED
   //One-Shot ADC Conversions
   WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_NR);//set the CELL_ADC_GO bit
   wait_ms(5);//delay for ADC accuracy
   
   //DORADI!
  // ReadReg(0, 0x215, void * bufferData, 12, 0, FRMWRT_SGL_R);// will return 6 overhead byte sand 12 data bytes per device, highest device address responds first
   //wait_ms(1);
   
   //Continuous ADC Conversions
   WriteReg(0, 0x25, 0x0A, 1, FRMWRT_ALL_NR);// enable continuous conversion with 5ms conversion interval
   WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_R);//set the CELL_ADC_GO bit
   waitFrame();

   wait_ms(5);//delay for ADC accuracy

   //da li je ovo ispod isto sto i Martin waitFrame? Ako jeste staviti ga u posebnu funkciju, ako nije proveriti da li je uopste potrebno
   //ReadReg(0, VCELL1H, response_frame, 6*2, 0, FRMWRT_ALL_R); //NJIHOV KOD
   //ReadReg(0, 0x215, void * bufferData, 12, 0, FRMWRT_SGL_R);// will return 6 overhead byte sand 12 data bytes per device, highest device address responds first
   wait_ms(1);//ISTA STVAR KAO IZNAD KOD ONE-SHOT
   
   
   while (1) {
        pc1.printf("Main Code \n");
        wait(2);
        //*****
        WriteReg(0, 2, 0x20, 1, FRMWRT_SGL_R); // send read sampled values command, OVO TREBA PROMENITI AKO VEC ZADRZAVAS OVAJ KOD!!!!!
        ReadReg(0, VCELL1H, response_frame, 6*2, 0, FRMWRT_ALL_R);  //PREPORUCEN KOD
        waitFrame();

        if(bmsLVFault)
            pc1.printf("- - - GRESKA FAULT! - - -\n");
    

    }
   
   
}
