#include <string>
using std::string;
#include "bq79606.h"

#define BaudR125k       0x303C
#define BaudR250k       0x343C
#define BaudR500k       0x383C
#define BaudR1M         0x3C3C


int UART_RX_RDY = 0;
int RTI_TIMEOUT = 0;







int main(void)
{
    //*************************************************************************************
    //NOTE:: PLEASE CHANGE "TOTALBOARDS" in bq79606.h file to change the number of devices
    //*************************************************************************************

    //VARIABLES
    BYTE response_frame[(MAXBYTES+6)*TOTALBOARDS];
    int currentBoard = 0;
    int i = 0;

    //TMS570 INITIALIZATION
    //systemInit();
    //gioInit();
    sciInit();
    //rtiInit();
    //vimInit();
    //_enable_IRQ();
    
    WakeUp();
    wait_ms(7*TOTALBOARDS); //tSU(WAKE) transition time from shutdown to active - 7ms from wake receive to wake propagate for each device
    AutoAddress();
    WriteReg(0, COMM_TO, 0x00, 1, FRMWRT_ALL_NR); //disable COMM timeout because printf takes a long time between reads
    WriteReg(0, SYSFLT1_FLT_RST, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //reset system faults
    WriteReg(0, SYSFLT1_FLT_MSK, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //mask system faults (so we can test boards and not worry about triggering these faults accidentally)

    //SET UP MAIN ADC
    WriteReg(0, CELL_ADC_CTRL, 0x3F, 1, FRMWRT_ALL_NR);     //enable conversions for all cells
    WriteReg(0, CELL_ADC_CONF2, 0x08, 1, FRMWRT_ALL_NR);    //set continuous ADC conversions, and set minimum conversion interval
    WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_NR);          //CELL_ADC_GO = 1
    wait_us(3*TOTALBOARDS+901);                             //3us of re-clocking delay per board + 901us waiting for first ADC conversion to complete

    //**********
    //MAIN LOOP
    //**********
    while(1)
    {
        //*******************
        //READ CELL VOLTAGES
        //*******************
        //reset variables
        i = 0;
        currentBoard=0;
        memset(response_frame, 0, sizeof(response_frame));

        //read back data (6 cells and 2 bytes each cell)
        ReadReg(0, VCELL1H, response_frame, 6*2, 0, FRMWRT_ALL_R);

        /*
         * ***********************************************
         * NOTE: SOME COMPUTERS HAVE ISSUES TRANSMITTING
         * A LARGE AMOUNT OF DATA VIA PRINTF STATEMENTS.
         * THE FOLLOWING PRINTOUT OF THE RESPONSE DATA
         * IS NOT GUARANTEED TO WORK ON ALL SYSTEMS.
         * ***********************************************
        */

        //PARSE, FORMAT, AND PRINT THE DATA
        printf("\n"); //start with a newline to add some extra spacing between loops
        for(currentBoard=0; currentBoard<TOTALBOARDS; currentBoard++)
        {
            //response frame actually starts with top of stack, so currentBoard is actually inverted from what it should be
            printf("BOARD %d:\t",TOTALBOARDS-currentBoard);

            //go through each byte in the current board (12 bytes = 6 cells * 2 bytes each)
            for(i=0; i<12; i+=2)
            {
                //each board responds with 32 data bytes + 6 header bytes
                //so need to find the start of each board by doing that * currentBoard
                int boardByteStart = (6*2+6)*currentBoard;

                //convert the two individual bytes of each cell into a single 16 bit data item (by bit shifting)
                uint16_t rawData = (response_frame[boardByteStart+i+4] << 8) | response_frame[boardByteStart+i+5];

                //do the two's complement of the resultant 16 bit data item, and multiply by 190.73uV to get an actual voltage
                float cellVoltage = Complement(rawData,0.00019073);

                //print the voltages - it is i/2 because cells start from 1 up to 6
                //and there are 2 bytes per cell (i value is twice the cell number),
                //and it's +1 because cell names start with "Cell1"
                printf("Cell %d = %f\t", (i/2)+1, cellVoltage);
            }
            printf("\n"); //newline per board
        }

        //***********************
        //END READ CELL VOLTAGES
        //***********************

    }
    //**************
    //END MAIN LOOP
    //**************

    return 0;
}

