/* mbed Microcontroller Library
 * Copyright (c) 2018 GigaDevice Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

/* 1 = Use DHCP */
/* 0 = Use default IP */
#define DEMO_DHCP_ENABLE        0

#if (0 == DEMO_DHCP_ENABLE)
#define DEVICE_IP       "192.168.57.156"
#define DEVICE_MASK     "255.255.255.0"
#define DEVICE_GATEWAY  "192.168.57.1"
#endif
    
const char html_contex[] = {
/* HTTP header */
/* "HTTP/1.0 200 OK
" (17 bytes) */
0x48,0x54,0x54,0x50,0x2f,0x31,0x2e,0x30,0x20,0x32,0x30,0x30,0x20,0x4f,0x4b,0x0d,
0x0a,
/* "Content-type: text/html
" (27 bytes) */
0x43,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x74,0x79,0x70,0x65,0x3a,0x20,0x74,0x65,
0x78,0x74,0x2f,0x68,0x74,0x6d,0x6c,0x0d,0x0a,0x0d,0x0a,
/* raw file data (380 bytes) */
0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,
0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,
0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x54,0x72,0x61,
0x6e,0x73,0x69,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x2f,0x2f,0x45,0x4e,0x22,0x20,0x22,
0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,
0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,
0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x74,0x72,0x61,0x6e,0x73,0x69,0x74,0x69,0x6f,
0x6e,0x61,0x6c,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,
0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,
0x68,0x74,0x6d,0x6c,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,
0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,
0x3d,0x22,0x43,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x54,0x79,0x70,0x65,0x22,0x20,
0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x68,0x74,
0x6d,0x6c,0x3b,0x20,0x63,0x68,0x61,0x72,0x73,0x65,0x74,0x3d,0x75,0x74,0x66,0x2d,
0x38,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,
0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x61,0x6c,0x69,
0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x20,0x20,
0x3c,0x68,0x31,0x3e,0x3c,0x73,0x74,0x72,0x6f,0x6e,0x67,0x3e,0x48,0x65,0x6c,0x6c,
0x6f,0x20,0x57,0x6f,0x72,0x6c,0x64,0x0d,0x0a,0x20,0x20,0x3c,0x2f,0x73,0x74,0x72,
0x6f,0x6e,0x67,0x3e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,
0x3e,0x0d,0x0a,0x3c,0x68,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x26,0x6e,
0x62,0x73,0x70,0x3b,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,
0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x0d,0x0a,};
    
EthernetInterface enet;

int main()
{
    nsapi_size_or_error_t result;
    
    printf("Mbed OS HTTP server example start \r\n");
    
#if (0 == DEMO_DHCP_ENABLE)
    /* Disable DHCP */
    enet.set_dhcp(0);
    enet.set_network(DEVICE_IP, DEVICE_MASK, DEVICE_GATEWAY);
#else
    /* Enable DHCP */
    enet.set_dhcp(1);
#endif
    
    if(enet.connect() != 0){
        printf("Network initialization failed \r\n");
        while(1);
    }else{
        printf("The device IP address is '%s' \r\n", enet.get_ip_address());
        printf("The device NetMask is '%s' \r\n", enet.get_netmask());
        printf("The device GateWay is '%s' \r\n", enet.get_gateway());
    }
    
    TCPServer http_srv;
    TCPSocket cli_sock;
    SocketAddress cli_addr;
    
    result = http_srv.open(&enet);
    if (result != 0) {
        printf("Error! http_srv.open() returned: %d\n", result);
    }
    
    /* Bind socket to the HTTP port(80) */
    result = http_srv.bind(enet.get_ip_address(), 80);
    if (result != 0) {
        printf("Error! http_srv.bind() returned: %d\n", result);
    }
    
    http_srv.listen(5);
    
    while (1) {
        http_srv.accept(&cli_sock, &cli_addr);
        printf("Server accept successful, remote is %s:%d\n", cli_addr.get_ip_address(), cli_addr.get_port());
        cli_sock.send(html_contex, sizeof(html_contex));
    }
}
