
//------------------------------------------------------------------------------
// Headers
//------------------------------------------------------------------------------

#include "mbed.h"
#include "BLE.h"
//#include "UARTService.h"
//#include "nrf.h"
//#include "nrf_temp.h"
//#include "nrf_gpio.h"




//------------------------------------------------------------------------------

BLE ble;


//------------------------------------------------------------------------------
// Inputs
//------------------------------------------------------------------------------

DigitalIn btn(P0_20);
InterruptIn btn_event(P0_20);

//------------------------------------------------------------------------------
// Outputs
//------------------------------------------------------------------------------

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//------------------------------------------------------------------------------
// Timers
//------------------------------------------------------------------------------

Ticker  t1;                                                                     //Temporizador 1
Ticker  t2;                                                                     //Temporizador 2
Ticker  t3;                                                                     //Temporizador 3

Ticker auxbtn;
Ticker pause;

//------------------------------------------------------------------------------
//-- Variables
//------------------------------------------------------------------------------

bool t1_start_cmd;                                                                //Variables del funcionamiento de temporizador 1
bool t1_running_flag;
bool t1_stop_cmd;
bool t1_pause_cmd;
bool t1_paused;
int t1_counter;

bool t2_start_cmd;                                                                //Variables del funcionamiento de temporizador 2
bool t2_running_flag;
bool t2_stop_cmd;
bool t2_pause_cmd;
bool t2_paused;
int t2_counter;

bool t3_start_cmd;                                                                //Variables del funcionamiento de temporizador 3
bool t3_running_flag;
bool t3_stop_cmd;
bool t3_pause_cmd;
bool t3_paused;
int t3_counter;

int pause_counter;

int t1_interval;                                                            // Intervalo en segundos del temporizador 1
int t2_interval;                                                            // Intervalo en segundos del temporizador 2
int t3_interval;
int pause_interval;                                                            // Intervalo en segundos del temporizador 3

int auxbtn_counter = 0;                                                        //Tiempo para rehabilitación de boton


//------------------------------------------------------------------------------
//-- Functions
//------------------------------------------------------------------------------

void btn_event_func();

void t1_func();
void t2_func();
void t3_func();
void pause_func();
void app_init();

void auxbtn_func();


// main() runs in its own thread in the OS
int main()
{
    app_init();

    ble.init();

    btn_event.fall(&btn_event_func);
    btn_event.enable_irq();

    t1_start_cmd = true;

    while (true) {




        if (t1_start_cmd) {
            t1_start_cmd = false;
            t1_counter = 0;
            t1.attach(t1_func,t1_interval);
        }

        if (t1_stop_cmd) {
            t1_stop_cmd = false;

            t1.detach();
            t1_running_flag = false;
            led1 = 1;
            t2_start_cmd = true;
        }


        if(t2_start_cmd) {
            t2_start_cmd = false;
            if (!t2_paused) {
                t2_counter = 0;
            }
            t2.attach(t2_func,t2_interval);
        }

        if (t2_stop_cmd) {
            t2_stop_cmd = false;

            t2.detach();
            t2_running_flag = false;
            led2 = 1;
            t3_start_cmd = true;
        }

        if(t3_start_cmd) {
            t3_start_cmd = false;
            if (!t3_paused) {
                t3_counter = 0;
            }
            t3.attach(t3_func,t3_interval);
        }

        if (t3_stop_cmd) {
            t3_stop_cmd = false;

            t3.detach();
            t3_running_flag = false;
            led3 = 1;
            t1_start_cmd = true;
        }

        //ble.waitForEvent();




        /*
        while (counter_t1 <= 10){
            led2 = !led2;
            led1 = false;
        }
        if (counter_t1 > 10){
            T1.detach();
            btn1_Event.enable_irq();
            t1_Stop = true;
        }
        led1 = !led1;
        wait(0.5);
        }*/


    }

}

void pause_func()
{
        led1 = 0;led2 = 0;led3 = 0;led4 = 0;
        wait_ms(100);
        led1=1;led2=1;led3=1;led4=1;
        pause_counter++;
}

void t1_func()
{

    if (t1_pause_cmd) {
        t1_pause_cmd = false;
        t1_paused = true;
        t1.detach();
    }

    if(t1_paused) {
        pause_counter = 0;
        pause.attach(pause_func,pause_interval);
    }
    if (!t1_paused) {

        led1 = 0;
        wait_ms(100);
        led1=1;
        t1_counter++;

        if (t1_counter == 1) {
            t1_running_flag = true;
        }

        if (t1_counter > 10) {
            t1_stop_cmd = true;
        }
    }


}

void t2_func()
{
    if (t2_pause_cmd) {
        t2_pause_cmd = false;
        t2_paused = true;
        t2.detach();
    }
    if(t2_paused) {
        pause_counter = 0;
        pause.attach(pause_func,pause_interval);
    }
    if (!t2_paused) {

        led2 = 0;
        wait_ms(100);
        led2=1;
        t2_counter++;

        if (t2_counter == 1) {
            t2_running_flag = true;
        }

        if (t2_counter > 15) {
            t2_stop_cmd = true;
        }
    }
}

void t3_func()
{
    if (t3_pause_cmd) {
        t3_pause_cmd = false;
        t3_paused = true;
        t3.detach();
    }
    if(t3_paused) {
        pause_counter = 0;
        pause.attach(pause_func,pause_interval);
    }
    if (!t3_paused) {

        led3 = 0;
        wait_ms(150);
        led3=1;
        t3_counter++;

        if (t3_counter == 1) {
            t3_running_flag = true;
        }

        if (t3_counter > 10) {
            t3_stop_cmd = true;
        }
    }
}

void app_init()
{
    led1 = led2 = led3 = led4 = 1;

    t1_start_cmd = false;                                                                //Variables del funcionamiento de temporizador 1
    t1_running_flag = false;
    t1_stop_cmd = false;
    t1_pause_cmd = false;
    t1_paused = false;
    t1_counter = 0;

    t2_start_cmd = false;                                                                //Variables del funcionamiento de temporizador 2
    t2_running_flag = false;
    t2_stop_cmd = false;
    t2_pause_cmd = false;
    t2_paused = false;
    t2_counter = 0;

    t3_start_cmd = false;                                                                //Variables del funcionamiento de temporizador 3
    t3_running_flag = false;
    t3_stop_cmd = false;
    t3_pause_cmd = false;
    t3_paused = false;
    t3_counter = 0;
    
    pause_counter = 0;

    t1_interval = 1;                                                            // Intervalo en segundos del temporizador 1
    t2_interval = 1;                                                            // Intervalo en segundos del temporizador 2
    t3_interval = 1;
    pause_interval = 1;                                                            // Intervalo en segundos del temporizador 3
}

void auxbtn_func()
{
    auxbtn_counter++;
    if (auxbtn_counter > 2) {
        btn_event.enable_irq();
        auxbtn.detach();
    }
}


void btn_event_func()
{
    btn_event.disable_irq();
    auxbtn_counter = 0;
    auxbtn.attach(auxbtn_func,1);
    if(t1_running_flag && !t1_paused) {
        t1_pause_cmd = true;
    }
    if(t2_running_flag && !t2_paused) {
        t2_pause_cmd = true;
    }
    if(t3_running_flag && !t3_paused) {
        t3_pause_cmd = true;
    }
    if(t1_paused) {
        t1_paused = false;
        t1.attach(t1_func,t1_interval);
        pause.detach();
        
    }
    if(t2_paused) {
        t2_paused = false;
        t2.attach(t2_func,t2_interval);
        pause.detach();
    }
    if(t3_paused) {
        t3_paused = false;
        t3.attach(t3_func,t3_interval);
        pause.detach();
    }
}