
/*
Programm für eine IIC LC-Display mit verschiedenen Formaten wie 16x2 16x4 20x4
Dieses Programm funktioniert mit einen
Adapter mit aufgelötetem Poti
nicht mit Poti zum auf die Seite klappen
G.Neumaier Feb 2018 getestet
*/

#include "mbed.h"
#include "TextLCD.h"

float mess0;
// I2C Communication
I2C i2c_lcd(PB_9,PB_8); // SDA, SCL  Nucleo F103RB Board
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type
//LCD Type possible for example: LCD16x2, LCD20x4
//!!Adress here is 0x4E normal adress 0x27, but thats the same, you have to shift left
//  Adress-shift:    0100 1110     <-   0010 0111 (0x27)

AnalogIn ana_A0(A0);      //same as Pin PA_0

int main()
{
    lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
    lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn ->!LightOff->on!
    lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn

//example for a display with 16x4 signs, a 16x2 display show you only two rows(Zeile) 
    while(1) {
        lcd.printf("Gerhard Neumaier\n" );   //   \n will produce newcolumn
        lcd.printf("  Offenburg \n" );       //   \n will produce newcolumn
        // lcd.printf("Number: %d-\n", 1265);   // dezimal number
        lcd.setAddress(2, 3);//column(Spalte), row (Zeile) beginning by0
        mess0 = ana_A0.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        mess0 = mess0*3.3;
        lcd.printf("Volt:%.3f\n", mess0);  //float number with 3signs behind comma
        //lcd.putc('-'); //one sign
        wait_ms(300);
    }
}