//LM35 auf Multifunktiionsshield A4 als Analogpin
// Achtung LM35 mit runder Seite nach unten einstecken, abgeflachte Seite Richtung Anzeige.
#include "mbed.h"
#include "ShiftReg.h"

AnalogIn LM35(A4);
int tempC;
unsigned short sensorValue;
//#define ANZEIGE_MASKE 0x00000FFF
//PortOut siebenSegPort(PortC, ANZEIGE_MASKE);
const unsigned int siebenSegWerte[] = {0x03,0x9F,0x25,0x0D,0x99,0x49,0x41,0x1F,0x01,0x09};
const unsigned int enableWerte[] = {0x10,0x20,0x040,0x80};
unsigned int ausgabeWerte[] = {0x03,0x03,0x03,0x03}; // 0 0 0 0
unsigned int pos=0;

ShiftReg HC595(D8, D4, D7);

//  -------------------------      -------------------------
// | D6 | D4 | D2 | D0 | GND |    | D6 | D4 | D2 | D0 | GND |
// |-------------------------|    |-------------------------|
// | D7 | D5 | D3 | D1 | VCC |    | D7 | D5 | D3 | D1 | VCC |
//  -------------------------      -------------------------
//  -------------------------      -------------------------
// | NC | NC | en2| en0| GND |    |  g |  e |  c |  a | GND |
// |-------------------------|    |-------------------------|
// | NC | NC | en3| en1| VCC |    | dot|  f |  d |  b | VCC |
//  -------------------------      -------------------------

void ausgabe();
void aufteilung();


int main()
{
    HC595.ShiftByte(0x00, ShiftReg::LSBFirst); HC595.Latch(); wait(0.2);//Grundstellung
    while(1) {
        sensorValue=LM35.read_u16();
        printf("measure = %i \n", sensorValue);
        ausgabe();
        wait_ms(1);
        aufteilung();
    }
}
void ausgabe()
{
    HC595.ShiftByte(ausgabeWerte[pos],ShiftReg::LSBFirst);
    HC595.ShiftByte(enableWerte[pos],ShiftReg::LSBFirst);
    HC595.Latch();
   
    pos++;
    pos=pos%4;
}
void aufteilung()
{
    tempC=(sensorValue*2000/65536);    //hier sollte eigentlich 3300/65536 stehen, dann ist aber der Anzeigewert zu hoch
                                         //Azeigewert 222 entspricht 22,2 Grad 
        ausgabeWerte[0]=siebenSegWerte[tempC%10]; // Einer
        ausgabeWerte[1]=siebenSegWerte[tempC%100/10]; //Zehner
        ausgabeWerte[2]=siebenSegWerte[tempC%1000/100]; // Hunderter
        ausgabeWerte[3]=siebenSegWerte[tempC/1000]; // Tausender
    
}