/* Copyright (c) 2019 Perlatecnica
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 04: SDcard                           *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/

#include "mbed.h"

// It includes the library that manages the File System
#include "FATFileSystem.h"

// It Includes the library that manage the SD at low level
#include "SDBlockDevice.h"

// It creates the File System variable
FATFileSystem fs("fs");

// it creates the reference to SD. The parameters are the pin for SPI bus
SDBlockDevice sd(D11, D12, D13, D10); //MOSI MISO SCK CS

Serial pc(USBTX, USBRX);

int main() {
    // It mounts the SD.
    fs.mount(&sd);

    // It opens the file mbed.txt. 'w' represents the access rights
    FILE *fd = fopen("/fs/mbed.txt", "w");

    if(fd==NULL) {
        // Something was wrong
        pc.printf("Error occurs writing the SD!\r\n");
    }
    else {
        fprintf(fd, "Welcome SD!!\r\n");
        fclose(fd);
        pc.printf("It works!\r\n");
    }
}
