/* Copyright (c) 2019 Perlatecnica
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************
*            RAPID PROTOTYPING WITH NUCLEO          *
* Example Code 03: Timer                            *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica                  *
*****************************************************/
/* Serial Client configuration                       *
* 9600 bauds, 8-bit data, no parity                 *
*****************************************************/

#include "mbed.h"

// It creates an instance of the Timer class. From now on, we can refer to the timer through its instance
Timer timer;

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// Entry point
int main() {
  // The timer is started calling its method 'start'. We refer to the Timer by the name of the instance
  timer.start();

  // It print to the serial client a string
  pc.printf("It works!\r\n");

  // Infinite loop. The instructions in the loop will be repeated forever
  while(1) { 
      wait(1);

      // The timer is read calling its method read_ms. It returns the elapsed time in ms
      pc.printf("This program runs since %d seconds.\r\n", timer.read_ms()/1000);

      // It change the led status. We will see the led blinking
      myled = !myled;
  }
}
 
// EXERCISE: Reset the board and looks what happens