/* Copyright (c) 2019 Perlatecnica
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************
*           RAPID PROTOTYPING WITH NUCLEO           *
* Example Code 02: Changing Serial baud             *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica                        *
*****************************************************
* Serial Client configuration                       *
* 115200 bauds, 8-bit data, no parity               *
*****************************************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);

int main() {
  // It changes the serial connection baudrate
  pc.baud(115200);
  
  // It prints the sting to serial terminal. YOU HAVE TO CHANGE ACCORDINGLY THE BAUDE RATE OF THE SERIAL CLIENT
  pc.printf("Hello World !\r\n");
}
