/* Copyright (c) 2019 Perlatecnica
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************
*             RAPID PROTOTYPING WITH NUCLEO         *
* Example Code 01: Serial                           *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica                        *
*****************************************************
* Serial Client configuration                       *
* 9600 bauds, 8-bit data, no parity                 *
*****************************************************/

#include "mbed.h"

// It creates an instance of the class Serial. 'pc' is the name of the variable and assign the TX and RX pin to it
Serial pc(USBTX, USBRX);

// Entry point
int main() {
  // Print to the serial console a string
  pc.printf("Hello World !\r\n");
  pc.printf("Here I'm !\r\n");
  pc.printf("It works !\r\n");
}

// OBSERVE THAT ONCE THE MESSAGES HAVE BEEN PRINTED, NOTHING ELSE HAPPENS

// EXERCISE: Modify the printed messages