#include "mbed.h"
#include "XNucleo53L0A1.h"
#include "rtos.h"
#include "Servo.h"
#include <stdio.h>

//BusOut myleds(LED4,LED3,LED2,LED1); //LEDS for debugging

Serial blue(p13,p14);
Serial pc(USBTX,USBRX);
Servo myservo(p21);
DigitalOut shdn(p26);
// This VL53L0X board test application performs a range measurement in polling mode
// Use 3.3(Vout) for Vin, p28 for SDA, p27 for SCL, P26 for shdn on mbed LPC1768

//I2C sensor pins
#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27

static XNucleo53L0A1 *board=NULL;

Thread lidar_thread;
Thread motor_thread;
Thread bluetooth_thread;

uint32_t volatile distance_copy;
int volatile status;
double volatile on_speed = 0.1;

Mutex distance_lock;
Mutex status_lock;
Mutex speed_lock;

void check_distance()
{
    uint32_t distance;
    
    //loop taking and printing distance
    while (1) 
    {
        distance_lock.lock();
        status_lock.lock();
        status = board->sensor_centre->get_distance(&distance);
        distance_copy = distance;
        
        // for debugging, print distance to pc
        if (status == VL53L0X_ERROR_NONE) 
        {
            pc.printf("D=%ld mm\r\n", distance_copy);
            pc.printf("D=%ld mm\r\n", distance);
        }
        distance_lock.unlock();
        status_lock.unlock();
    }

}

void fan_control()
{   
    while (1)
    {
        //status_lock.lock();
        //distance_lock.lock();
        speed_lock.lock();
        //pc.printf("inside\n");
        if (status == VL53L0X_ERROR_NONE)
        {
            if (distance_copy <= 610) // within 2 feet (distance is in mm)
            {
                myservo = on_speed;
                //pc.printf("on\n");
            }
            else
            {
                myservo = 0;
                //pc.printf("off\n");
            }
            
        }
        //status_lock.unlock();
        //distance_lock.unlock();
        speed_lock.unlock();

        Thread::yield();
    }
}

void speed_control()
{
    char bnum=0;
    char bhit=0;
    //myleds = 0;
    while(1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    switch (bnum) {
                        
                        case '5': //button 5 up arrow - Increase fan speed.
                            if (bhit=='1') 
                            {
                                if( on_speed <= 0.2 )
                                { 
                                    speed_lock.lock();
                                    on_speed = on_speed + 0.02;
                                    speed_lock.unlock();
                                    //myleds = myleds + 1; 
                                }
                            }
                            break;
                            
                        case '6': //button 6 down arrow - Decrease fan speed.
                            if (bhit=='1') {
                                if( on_speed >= 0.0 )
                                { 
                                    speed_lock.lock();
                                    on_speed = on_speed - 0.02;
                                    speed_lock.unlock();
                                //myleds = myleds - 1;
                                }
                            }
                            break;
                            
                        case '1': //button 1 - Turn fan on.
                            if (bhit=='1') {
                                speed_lock.lock();
                                on_speed = 0.1;
                                speed_lock.unlock();
                             //myleds = 0;
                            } 
                            break;
                        
                        case '2': //button 2 - Turn fan off.
                            if (bhit=='1') {
                                speed_lock.lock();
                                on_speed = 0.0;
                                speed_lock.unlock();
                             //myleds = 0;
                            } 
                            break;
                    }
                }
            }
        }
    }
}


int main()
{
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    
    shdn = 0; //must reset sensor for an mbed reset to work
    Thread::wait(100);
    shdn = 1;
    Thread::wait(100);
    
    status_lock.lock();
    /* init the 53L0A1 board with default values */
    status = board->init_board();
    
    while (status) 
    {
        pc.printf("Failed to init board! \r\n");
        status = board->init_board();
        Thread::yield();
    }
    status_lock.unlock();
    
    myservo = 0.0;

    while(1)
    {
        lidar_thread.start(check_distance);
        motor_thread.start(fan_control);
        bluetooth_thread.start(speed_control);
    }
}
