/*CODE TEST ADC ADS1220*/
/*ADS1220 LIBRARY MODIFIED OF SANDEEP MALLADI*/
/*https://developer.mbed.org/users/sandeepmalladi/code/ADS1220*/

#include "mbed.h"
#include "ADS1220.h"



#define PGA 1                 // Programmable Gain = 1
#define VREFE 5.0                // External reference of 5.00V
#define VFSR VREFE/PGA
#define FSR (((long int)1<<23))
#define LSB_Size (VFSR/FSR)

Serial pc(USBTX, USBRX);
ADS1220 ads1220_com(PTD2, PTD3, PTD1);
DigitalIn DRDY(D0);

Timer t;

void showvolt(float volts);
float code2volt(float c);
signed long t1Data, t2Data;
float Vout, volt;
char AIN1 = 57, AIN2 = 56;
int chn;

int main(){
    pc.baud (230400);   //Set a baudrate to unusual value of the 230400bps
    pc.printf("ADS1220 Inicializing\n\r");
    ads1220_com.Config();
    //Configure ADS1220 to Single Shot, Turbo Mode & 2000sps
    pc.printf("ADS1220 Configured and Inicialized\n\r");

    
    wait_ms(500);
    
    while(1) {     
        t.start(); //Start Timer to Count Time Lapse
        
        ads1220_com.set_MUX(AIN1); //Configure to Sample Channel 1
        ads1220_com.SendStartCommand(); //Start Aquisition
        while (DRDY != 0){} // Wait data on Buffer
        t1Data = ads1220_com.ReadData(); //Read Data Sampled on Channel 1
                        
        ads1220_com.set_MUX(AIN2); //Configure to Sample Channel 2
        ads1220_com.SendStartCommand(); //Start Aquisition
        while (DRDY != 0){} // Wait data on Buffer
        t2Data = ads1220_com.ReadData(); //Read Data Sampled on Channel 2
        
        pc.printf("AIN1 %f - AIN2 %f \n\r",code2volt(t1Data), code2volt(t2Data)); //Print Data Formated
        t.stop();//Stop Timer to Count Time Lapse

        pc.printf("TEMPO %f \n\r", t.read()); //Print Time Lapse
        t.reset(); //Reset Timer Counter

    }
}

//Function to Convert ADC Data Read
float code2volt(float c)
{
    float Vout = 0;
    Vout = (float)(c*LSB_Size*1000);    //In  mV
    return Vout;
}
