/*******************************************************************************
* File Name          : ST7565_LCD.c
* Author             : Walter Trovò
* Date First Issued  : 20/03/2012
*******************************************************************************/

// ST7565R LCD module driver

#ifndef __ST7565_LCD_H
#define __ST7565_LCD_H

#include "mbed.h"

// LCD commands and definitions

#define LCD_WIDTH   128
#define LCD_HEIGHT  64

#define CMD_DISPLAY_OFF   0xAE
#define CMD_DISPLAY_ON    0xAF

#define CMD_SET_DISP_START_LINE  0x40
#define CMD_SET_PAGE  0xB0

#define CMD_SET_COLUMN_UPPER  0x10
#define CMD_SET_COLUMN_LOWER  0x00

#define CMD_SET_ADC_NORMAL  0xA0
#define CMD_SET_ADC_REVERSE 0xA1

#define CMD_SET_DISP_NORMAL 0xA6
#define CMD_SET_DISP_REVERSE 0xA7

#define CMD_SET_ALLPTS_NORMAL 0xA4
#define CMD_SET_ALLPTS_ON  0xA5
#define CMD_SET_BIAS_9 0xA2 
#define CMD_SET_BIAS_7 0xA3

#define CMD_RMW  0xE0
#define CMD_RMW_CLEAR 0xEE
#define CMD_INTERNAL_RESET  0xE2
#define CMD_SET_COM_NORMAL  0xC0
#define CMD_SET_COM_REVERSE  0xC8
#define CMD_SET_POWER_CONTROL  0x28
#define CMD_SET_RESISTOR_RATIO  0x20
#define CMD_SET_VOLUME_FIRST  0x81
#define CMD_SET_VOLUME_SECOND  0
#define CMD_SET_STATIC_OFF  0xAC
#define CMD_SET_STATIC_ON  0xAD
#define CMD_SET_STATIC_REG  0x0
#define CMD_SET_BOOSTER_FIRST  0xF8
#define CMD_SET_BOOSTER_234  0
#define CMD_SET_BOOSTER_5  1
#define CMD_SET_BOOSTER_6  3
#define CMD_NOP  0xE3
#define CMD_TEST  0xF0

#define swap(a, b) { unsigned short t = a; a = b; b = t; }

// ------------- Functions prototype -----------------


void SPI_Write(uint8_t data);
void LCD_cmd(uint8_t command);
void LCD_data(uint8_t data);
void LCD_reset(void);
void LCD_set_contrast(unsigned int level);
void LCD_write_buffer(unsigned int *buffer);
void LCD_clear(void);
void LCD_setpixel(unsigned int *buff, uint8_t x, uint8_t y, uint8_t color);
void LCD_clearpixel(unsigned int *buff, uint8_t x, uint8_t y);
void LCD_drawline(unsigned int *buff, uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t color);
void LCD_drawchar(unsigned int *buff, uint8_t x, uint8_t line, char c);
void LCD_drawstring(unsigned int *buff, uint8_t x, uint8_t line, char *c);
void Clear_buffer(unsigned int *buff);

#endif
