

#include "mbed.h"
#include "ST7565_LCD.h"
#include "font_5x7.h"

unsigned int lcd_orientation, lcd_width, lcd_height;
unsigned int p_size, p_x, p_y, p_bg, p_fg;

//extern const unsigned short font_PGM[];

int pagemap[] = { 0, 1, 2, 3, 4, 5, 6, 7 };
/*
// CAUTION HIGH VOLTAGE
unsigned int buffer[128*64/8] = { 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0xE0, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
0xF8, 0x0C, 0x04, 0x04, 0x04, 0x0C, 0x08, 0x00, 0x80, 0xF0, 0x7C, 0x0C, 0x7C, 0xF0, 0x80, 0x00,
0x00, 0xFC, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0xFC, 0x00, 0x04, 0x04, 0x04, 0xFC, 0xFC, 0x04, 0x04,
0x04, 0x00, 0xFC, 0xFC, 0x00, 0x00, 0xF0, 0xF8, 0x0C, 0x04, 0x04, 0x0C, 0xF8, 0xF0, 0x00, 0x00,
0xFC, 0xFC, 0x38, 0xE0, 0x80, 0xFC, 0xFC, 0x00, 0x00, 0xFC, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF0, 0xFC, 0xFF,
0xFF, 0x3F, 0x0F, 0x07, 0x01, 0x00, 0x01, 0x07, 0x0F, 0x3F, 0xFF, 0xFE, 0xFC, 0xF0, 0xC0, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
0x07, 0x0C, 0x08, 0x08, 0x08, 0x0C, 0x04, 0x0C, 0x0F, 0x03, 0x02, 0x02, 0x02, 0x03, 0x0F, 0x0C,
0x00, 0x07, 0x0F, 0x08, 0x08, 0x08, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00,
0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x03, 0x07, 0x0C, 0x08, 0x08, 0x0C, 0x07, 0x03, 0x00, 0x00,
0x0F, 0x0F, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x00, 0x00, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0xFE, 0xFF, 0x7F, 0x1F, 0x07, 0x01,
0x00, 0x80, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x3C, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x3F, 0xFF,
0xFE, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0x10, 0x10, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFC, 0xFE, 0x03,
0x01, 0x21, 0x21, 0xE3, 0xE2, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x10, 0xFF, 0xFF, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xC0, 0xE0, 0xF8, 0xFE, 0xFF, 0x7F, 0x1F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0xC0,
0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F, 0x07, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x03, 0x07, 0x1F, 0x7F, 0xFF, 0xFE, 0xF8, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x80, 0xC0, 0x40, 0x40,
0xC3, 0x83, 0x00, 0x00, 0x00, 0xC3, 0xC3, 0x00, 0x00, 0x03, 0x03, 0x00, 0x40, 0x40, 0x41, 0xC3,
0xC2, 0x42, 0x42, 0x43, 0x01, 0x00, 0x00, 0xC3, 0xC3, 0xC0, 0x00, 0x00, 0x03, 0x03, 0x00, 0x80,
0xC0, 0x40, 0x40, 0x40, 0xC0, 0x80, 0x00, 0x00, 0xC0, 0xC0, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF8,
0xFC, 0xFF, 0x7F, 0x3F, 0x0F, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xFC, 0x7F,
0x7F, 0x3F, 0x3F, 0x1F, 0x1C, 0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x07, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1F, 0x7F, 0xFF, 0xFC, 0xF8, 0xE0, 0x80, 0x00, 0x00,
0x00, 0x00, 0x07, 0x3F, 0xF8, 0xC0, 0xF8, 0x3F, 0x07, 0x00, 0x00, 0x3F, 0x7F, 0xC0, 0x80, 0x80,
0xC0, 0x7F, 0x3F, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFF,
0xFF, 0x00, 0x00, 0x00, 0xC0, 0xF8, 0x3F, 0x27, 0x20, 0x27, 0x3F, 0xF8, 0xC0, 0x00, 0x3F, 0x7F,
0xC0, 0x80, 0x88, 0x88, 0xF8, 0x78, 0x00, 0x00, 0xFF, 0xFF, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xF0, 0xFC, 0xFE, 0xFF, 0x3F, 0x1F,
0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0xFC, 0xFF, 0xFF, 0x3F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x0F, 0x3F, 0x7F, 0xFF, 0xFC,
0xF0, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0xFE, 0xFF, 0x7F, 0x1F, 0x07, 0x03, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x01, 0x0F, 0xFF, 0xFF, 0x3F, 0x0F, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07,
0x0F, 0x3F, 0xFF, 0xFF, 0xFC, 0xF0, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x1E, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
*/

// GEO ELECTRONICS 2017
unsigned int buffer[128*64/8] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xE0, 0xC0,
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0x30, 0x10, 0x08, 0x08, 0x58, 0x78,
0x30, 0x00, 0x00, 0xC8, 0xF8, 0xB8, 0xC8, 0xC8, 0x08, 0x18, 0x18, 0x08, 0xC0, 0xE0, 0x30, 0x10,
0x08, 0x08, 0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0xC0, 0xC0, 0xE0, 0xE0, 0xF0, 0xF8, 0x78, 0x3C, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F, 0x1F,
0x9F, 0xDF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xE0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x1F, 0x10, 0x10, 0x19, 0x0D, 0x0F, 0x03, 0x11,
0x10, 0x9C, 0x9F, 0x93, 0x90, 0x11, 0x19, 0x08, 0x00, 0x00, 0x00, 0x0F, 0x1B, 0x10, 0x10, 0x08,
0x0C, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0x7F, 0x0F, 0x07, 0x03, 0x00, 0x00, 0xE0, 0xE0, 0xF8, 0xFC, 0x7E, 0xDE, 0xE0,
0xF7, 0xFF, 0xFF, 0xFF, 0xFD, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xF8,
0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xB8, 0x2C, 0x2C, 0xAC, 0x38, 0x00, 0xC0,
0xF0, 0x3C, 0x0F, 0xC3, 0xF0, 0xB8, 0x2C, 0x2C, 0xAC, 0x38, 0x00, 0xC0, 0xF0, 0xB8, 0x0C, 0x0C,
0x84, 0x0C, 0xC0, 0xF4, 0x3C, 0x0F, 0x84, 0x04, 0x00, 0xC4, 0xFC, 0x38, 0x0C, 0x04, 0xEC, 0xF0,
0x98, 0x0C, 0x84, 0xCC, 0x78, 0x00, 0x80, 0xF4, 0x3C, 0x0C, 0xC4, 0x3C, 0x1C, 0x00, 0xC0, 0xF4,
0x3C, 0x0C, 0xC0, 0xF0, 0xB8, 0x08, 0x0C, 0x84, 0x0C, 0x80, 0xB8, 0x3C, 0xE4, 0xCC, 0x08, 0x00,
0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xE3, 0x47, 0x1F,
0x0F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x81, 0xC6, 0xEF, 0xF7,
0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,
0x3F, 0x1F, 0x1F, 0xFC, 0xF0, 0xE0, 0xC0, 0x80, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01,
0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01,
0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01,
0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
0x06, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0xFF, 0x80, 0x00, 0x41, 0xE1, 0xF3, 0xFF, 0xFF, 0xFF, 0xFE,
0xFE, 0xFE, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80, 0x00, 0x06, 0x1F, 0x3F, 0x7F, 0x7F, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFD, 0x0D, 0x04, 0x00,
0x00, 0x00, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x1E, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1F, 0x7C, 0xE0, 0x80, 0x01, 0x03, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x77, 0x7B, 0x7D, 0x3E, 0x00, 0x80,
0xE0, 0x78, 0x3F, 0x0F, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0xC7, 0xEE, 0xFF, 0xFF, 0xFF,
0xFF, 0xE3, 0xC1, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x01, 0x03, 0x83, 0x83, 0xC3, 0xC3, 0xE1, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xF7, 0xF3,
0xF1, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03,
0x03, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1F, 0x3F, 0x7E, 0xFE, 0xFE, 0x7E, 0x3E, 0x1E,
0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x07,
0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

 
extern const unsigned short font_PGM[];


DigitalOut  LCD_RST (D9);     // D7=PA8--> LCD Reset
DigitalOut  LCD_CS  (D10);    // D10=PB6--> LCD Chip-Select 
DigitalOut  LCD_SDI (D11);    // D11=PA7--> LCD Serial Data In
DigitalOut  LCD_A0  (D12);    // D12=PA6--> LCD A0
DigitalOut  LCD_CLK (D13);    // D13=PA5--> LCD Serial Clock


//==============================================================================

void Delay_us(int howmany)
{
  int n;
  Timer t;
  t.start();
  do
  {
    n=t.read_us();
  }
  while (n<= howmany);
}


//==============================================================================


void SPI_Write(uint8_t data)
{

    uint8_t mask;  

    for(mask=0x80; mask!=0; mask>>=1)
    {
      LCD_CLK=0;
      if(mask & data)
        LCD_SDI=1;
        
      else
        LCD_SDI=0;
        
      LCD_CLK=1;
      
    }
    LCD_CLK=0;

    return;
}


//==============================================================================

void LCD_cmd(uint8_t command)
{
  
  LCD_A0=0;
  
  LCD_CS=0;
  SPI_Write(command);
  LCD_CS=1;

  return;
}


//==============================================================================

void LCD_data(uint8_t data)
{
  LCD_A0=1;
  
  LCD_CS=0;
  SPI_Write(data);
  LCD_CS=1;
  
  return;
}



//==============================================================================

void LCD_clear(void) 
{
  unsigned int p, c;
  
  for(p = 0; p < 8; p++) 
  {
    LCD_cmd(CMD_SET_PAGE | p);
    for(c = 0; c < 128; c++) 
    {
      LCD_cmd(CMD_SET_COLUMN_LOWER | (c & 0xf));
      LCD_cmd(CMD_SET_COLUMN_UPPER | ((c >> 4) & 0xf));
      LCD_data(0x0);
    }     
  }
  
  return;
}


//==============================================================================


void LCD_reset(void)
{

  // toggle RST low to reset; CS high
  LCD_CS=1;
  LCD_RST=0;    
  wait(0.01);
  LCD_RST=1;  

  LCD_cmd(CMD_SET_BIAS_7);  // LCD bias select
  LCD_cmd(CMD_SET_ADC_NORMAL);  // ADC select ===
  LCD_cmd(CMD_SET_COM_REVERSE);  // SHL select
  LCD_cmd(CMD_SET_DISP_START_LINE);  // Initial display line  
  
  LCD_cmd(CMD_SET_POWER_CONTROL | 0x4);  // turn on voltage converter (VC=1, VR=0, VF=0)
  wait(0.01);
  LCD_cmd(CMD_SET_POWER_CONTROL | 0x6);  // turn on voltage regulator (VC=1, VR=1, VF=0)
  wait(0.01);
  LCD_cmd(CMD_SET_POWER_CONTROL | 0x7);  // turn on voltage follower (VC=1, VR=1, VF=1)
  wait(0.01);

  // set lcd operating voltage (regulator resistor, ref voltage resistor)
  LCD_cmd(CMD_SET_RESISTOR_RATIO | 0x6);
  
  LCD_cmd(CMD_DISPLAY_ON);
  LCD_cmd(CMD_SET_ALLPTS_NORMAL);
  
  // set contrast (leve= 0x09)
  LCD_cmd(CMD_SET_VOLUME_FIRST);
  LCD_cmd(CMD_SET_VOLUME_SECOND | (0x07 & 0x3f));
  LCD_clear();  
    
  return;
}

//==============================================================================

void LCD_write_buffer(unsigned int *buffer) 
{
  unsigned int c, p;

  for(p = 0; p < 8; p++) 
  {
    LCD_cmd(CMD_SET_PAGE | pagemap[p]);
    LCD_cmd(CMD_SET_COLUMN_LOWER | (0x0 & 0xf));
    LCD_cmd(CMD_SET_COLUMN_UPPER | ((0x0 >> 4) & 0xf));
    LCD_cmd(CMD_RMW);
    LCD_data(0xFF); // X-axis offset
    LCD_data(0xFF);
    LCD_data(0xFF);
    LCD_data(0xFF);    
    
    for(c = 0; c < 128; c++) 
    {
      LCD_data(buffer[(128*p)+c]);
    }
  }
  
  return;
  
}




//==============================================================================

void LCD_setpixel(unsigned int *buff, uint8_t x, uint8_t y, uint8_t color) 
{
  if ((x >= LCD_WIDTH) || (y >= LCD_HEIGHT))
    return;

  if (color) 
    buff[x+ (y/8)*128] |= (7-(y%8));  
  else
    buff[x+ (y/8)*128] &= ~(7-(y%8)); 
  
  return;
}


//==============================================================================

void LCD_clearpixel(unsigned int *buff, uint8_t x, uint8_t y) 
{
  if ((x >= LCD_WIDTH) || (y >= LCD_HEIGHT))
    return;
  
  buff[x+ (y/8)*128] &= ~(7-(y%8));
  
  return;
}


//==============================================================================

void LCD_drawline(unsigned int *buff, uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t color) 
{
  uint8_t steep = abs(y1 - y0) > abs(x1 - x0);

  if (steep) {
    swap(x0, y0);
    swap(x1, y1);
  }

  if (x0 > x1) {
    swap(x0, x1);
    swap(y0, y1);
  }

  uint8_t dx, dy;
  dx = x1 - x0;
  dy = abs(y1 - y0);

  int err = dx / 2;
  int ystep;

  if (y0 < y1) {
    ystep = 1;
  } else {
    ystep = -1;}

  for (; x0<x1; x0++) {
    if (steep) {
      LCD_setpixel(buff, y0, x0, color);
    } else {
      LCD_setpixel(buff, x0, y0, color);
    }
    err -= dy;
    if (err < 0) {
      y0 += ystep;
      err += dx;
    }
  }
  
  return;  
}


//==============================================================================

void LCD_drawchar(unsigned int *buff, uint8_t x, uint8_t line, char c) 
{
  uint8_t i;
  
  for (i =0; i<5; i++ ) 
  {
    buff[x + (line*128) ] = font_PGM[((c-32)*5)+i];    
    x++;
  }
  
  return;
}


//==============================================================================
// The 128x64 LCD allows 8 rows of 21 chars

void LCD_drawstring(unsigned int *buff, uint8_t x, uint8_t line, char *c) 
{
  unsigned int i=0;
  while (c[i] != 0) 
  {
    LCD_drawchar(buff, x, line, c[i]);
    i++;
    x += 6; // 6 pixels wide
    if (x + 6 >= LCD_WIDTH) {
      x = 0;    // ran out of this line
      line++;
    }
    if (line >= (LCD_HEIGHT/8))
      return;        // ran out of space :(
  }
  
  return;  
}


//==============================================================================

void Clear_buffer(unsigned int *buff) 
{
  unsigned short i;
  
  for(i=0; i<1024; i++)
    buff[i]=0x00;
  
  return;
}