#include "mbed.h"
#include "Servo.h"
#include "iostream"
#include "string"
#include "QEI.h"
#include "Timer.h"
#define RATE 0.05

Timer timer1; // define timer object
//DECLARATIONS
//leds:
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(p22);
//InterruptIn button(p10);
//inputs:
//push button reset : nR
DigitalIn button(p10);
AnalogIn force_in(p17);

void bouton();
//outputs:
//analog Output (état du coude ou du capteur de force)
AnalogOut elbow_angle_out(p18);
//Servomoteur
Servo myservo (p26);

//PROGRAM
int main()
{
    //braking parameters
    int initial_offset;
    int elbow_angle;
    int a=0;
    Timer t;
    Timer t_attelle;
    t_attelle.start();
    float val_frein=0.1;
    float force_in_volt;
    char buffer[128];
    char buffer2[128];
    int reset=1;
    float val_force;
    myled=0;
    myled2=0;
    myled3=0;
    myled4=0;
    myservo = val_frein;
    QEI wheel (p5, p6, p7, 2048, QEI::X4_ENCODING);
    
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    pc.printf("Elbow Perturbation with Viscous Friction vdemo 2019\r\n");
   


    timer1.start(); // start timer counting while(1) { if (timer1.read_ms()>=200) // read time in ms

    while(1) {
        if (reset==1) {
            myled4=0;
            //Calibration
            pc.printf("Set Elbow at 90 degrees (aligned) and maintain it\r\n");
            wait(1);
            pc.printf("Hold and don't move\r\n");
            myled4=1;
            wait(0.5);
            initial_offset = wheel.getPulses();
            myled4=0;
            wait(0.5);
            pc.printf("Elbow encoder calibrated\r\n");
            myled4=1;
            wait(1);
            reset=0;
        }

        if ( pc.readable() ) {
            //tant que le bouton n'est pas appuyé, le programme attendra une nouvelle valeur à mettre dans le buffer
            pc.gets(buffer, 3);
            buffer2[0]=buffer[1]; //met la valeur passée au clavier dans buffer2[0] pour ne transformer que cette valeur en entier (atoi)
            a= atoi(buffer2);

            if (buffer[0]=='f') {
                switch (a) {
                    case 9:
                        val_frein=0.75;
                        break;
                    case 8:
                        val_frein=0.70;
                        break;
                    case 7:
                        val_frein=0.65;
                        break;
                    case 6:
                        val_frein=0.60;
                        break;
                    case 5:
                        val_frein=0.55;
                        break;
                    case 4:
                        val_frein=0.45;
                        break;
                    case 3:
                        val_frein=0.4;
                        break;
                    case 2:
                        val_frein=0.35;
                        break;
                    case 1:
                        val_frein=0.3;
                        break;
                    case 0:
                        val_frein=0.25;
                        break;
                    default:
                        break;
                }
            }
        }//if readable

        if (button==1) {
            myservo = 0.85;
        } else {
            myservo = val_frein;
        }

        if (timer1.read_ms()>=5) {
            elbow_angle=90-((wheel.getPulses()-initial_offset)*360/8192);
            force_in_volt=force_in.read()*10;
            
            //pc.printf("percentage: %f\r\n", force_in.read());       
            pc.printf("%d - %f \r\n", elbow_angle, force_in_volt);
            
        
            
            
            
            //pc.printf("\r%d", elbow_angle);
            //val_force=force*1000;
            //pc.printf("f");
            //pc.printf("%.0f", val_force);
            timer1.reset(); // reset timer
        }

//          wait(RATE);


    }//while(1)

}//main()

