#include "mbed.h"

AnalogIn SIG_pin(p18);

//======Declared all the ADC Values as digital outputs, so that they don't affect ADC readingd
DigitalOut ADC1(p15);
DigitalOut ADC2(p16);
DigitalOut ADC3(p17);
DigitalOut ADC4(p19);


DigitalOut s0(p21);
DigitalOut s1(p20);
DigitalOut s2(p23);
DigitalOut s3(p24);


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


Serial pc(USBTX, USBRX); // tx, rx

int readMux(int channel){

  int muxChannel[16][4]={
    {0,0,0,0}, //channel 0
    {1,0,0,0}, //channel 1
    {0,1,0,0}, //channel 2
    {1,1,0,0}, //channel 3
    {0,0,1,0}, //channel 4
    {1,0,1,0}, //channel 5
    {0,1,1,0}, //channel 6
    {1,1,1,0}, //channel 7
    {0,0,0,1}, //channel 8
    {1,0,0,1}, //channel 9
    {0,1,0,1}, //channel 10
    {1,1,0,1}, //channel 11
    {0,0,1,1}, //channel 12
    {1,0,1,1}, //channel 13
    {0,1,1,1}, //channel 14
    {1,1,1,1}  //channel 15
  };

  //loop through the 4 sig
/*  for(int i = 0; i < 4; i ++){
    controlPin[i] = muxChannel[channel][i];
  }
*/
    s0 = muxChannel[channel][0];
    s1 = muxChannel[channel][1];
    s2 = muxChannel[channel][2];
    s3 = muxChannel[channel][3];
    
    led1= muxChannel[channel][0]; 
    led2= muxChannel[channel][1];
    led3= muxChannel[channel][2]; 
    led4= muxChannel[channel][3];
    
  //read the value at the SIG pin
  int val = SIG_pin.read_u16();

  //return the value
  return val;
}



int main(){

  //Loop through and read all 16 values
  //Reports back Value at channel 6 is: 346
  //int DATA[][13] = {0};
  int c;
    while(1){
      for(int i = 0; i < 10; i ++){
        pc.printf("C");
        pc.printf("%d",i);
        pc.printf("is : ");
        //DATA[i][c] = readMux(i);
        pc.printf("%d", readMux(i));
        pc.printf(" , ");
        wait(0.3);
      }
      pc.printf("\r\n");
      c++; //(no. of time incriments increases)
      wait(5); //take readings every (300 is 5 mins)
    }
}