#include "mbed.h" 
#include "arduino.h" 
using namespace std;
DigitalOut myled(LED1);

// constants: 
DigitalIn sensorPin1(p5);
// variables:   
int counter = 0;
// counter for the number of products passing through   
int sensorState1 = 0;
// current state of the sensor   
int lastSensorState1 = 0;
// previous state of the sensor 
// initialize serial communication:   
Serial pc(USBTX, USBRX);
Serial.baud(9600);

int main()
{
    while(1)
    {
        // read the pushbutton input pin:       
        sensorState1 = digitalRead(sensorPin1);
        // compare the buttonState to its previous state         
        if (sensorState1 != lastSensorState1)
        {
            // if the state has changed, check to see if it is a change from high to low or low to high             
            if (sensorState1 == HIGH)
            {
                // if the current state is HIGH then increment the counter                        
                counter++;
                Serial.println(counter);
            }
            else
            {
                // if the current state is LOW then the button       
                Serial.println(counter);
            }
        }
        // save the current state as the last state,    
        //for next time through the loop   
        lastSensorState1 = sensorState1;
        //pause to aviod spikes   delay(20);
    }
}