#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "MDM.h"
#include "GPS.h"

DigitalOut led(LED);
void hello() {
    led = !led;
}

int main() {
    printf("Starting\r\n");
    wait(5);
    printf("Modem on\r\n");
    MDMSerial mdm;
    wait(5);
    printf("GPS on\r\n");
    GPSI2C gps;
    wait(5);
    printf("PHY off\r\n");
    PHY_PowerDown();
    wait(5);
    printf("Modem off\r\n");
    mdm.powerOff();
    wait(5);
    printf("GPS off\r\n");
    gps.powerOff();
    printf("Sleeping\r\n");
    Timeout t;
    t.attach(&hello, 5.0f);
    Sleep();
    printf("Woke up\r\n");
    while (true);
}