/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_AXBS_REGISTERS_H__
#define __HW_AXBS_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 AXBS
 *
 * Crossbar switch
 *
 * Registers defined in this header file:
 * - HW_AXBS_PRSn - Priority Registers Slave
 * - HW_AXBS_CRSn - Control Register
 * - HW_AXBS_MGPCR0 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR1 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR2 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR3 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR4 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR5 - Master General Purpose Control Register
 *
 * - hw_axbs_t - Struct containing all module registers.
 */

#define HW_AXBS_INSTANCE_COUNT (1U) /*!< Number of instances of the AXBS module. */

/*******************************************************************************
 * HW_AXBS_PRSn - Priority Registers Slave
 ******************************************************************************/

/*!
 * @brief HW_AXBS_PRSn - Priority Registers Slave (RW)
 *
 * Reset value: 0x00543210U
 *
 * The priority registers (PRSn) set the priority of each master port on a per
 * slave port basis and reside in each slave port. The priority register can be
 * accessed only with 32-bit accesses. After the CRSn[RO] bit is set, the PRSn
 * register can only be read; attempts to write to it have no effect on PRSn and
 * result in a bus-error response to the master initiating the write. Two available
 * masters must not be programmed with the same priority level. Attempts to
 * program two or more masters with the same priority level result in a bus-error
 * response and the PRSn is not updated. Valid values for the Mn priority fields
 * depend on which masters are available on the chip. This information can be found in
 * the chip-specific information for the crossbar. If the chip contains less
 * than five masters, values 0 to 3 are valid. Writing other values will result in
 * an error. If the chip contains five or more masters, valid values are 0 to n-1,
 * where n is the number of masters attached to the AXBS module. Other values
 * will result in an error.
 */
typedef union _hw_axbs_prsn
{
    uint32_t U;
    struct _hw_axbs_prsn_bitfields
    {
        uint32_t M0 : 3;               /*!< [2:0] Master 0 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED0 : 1;        /*!< [3]  */
        uint32_t M1 : 3;               /*!< [6:4] Master 1 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED1 : 1;        /*!< [7]  */
        uint32_t M2 : 3;               /*!< [10:8] Master 2 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED2 : 1;        /*!< [11]  */
        uint32_t M3 : 3;               /*!< [14:12] Master 3 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED3 : 1;        /*!< [15]  */
        uint32_t M4 : 3;               /*!< [18:16] Master 4 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED4 : 1;        /*!< [19]  */
        uint32_t M5 : 3;               /*!< [22:20] Master 5 Priority. Sets the arbitration
                                        * priority for this port on the associated slave port. */
        uint32_t RESERVED5 : 9;        /*!< [31:23]  */
    } B;
} hw_axbs_prsn_t;

/*!
 * @name Constants and macros for entire AXBS_PRSn register
 */
/*@{*/
#define HW_AXBS_PRSn_COUNT (5U)

#define HW_AXBS_PRSn_ADDR(x, n)  ((x) + 0x0U + (0x100U * (n)))

#define HW_AXBS_PRSn(x, n)       (*(__IO hw_axbs_prsn_t *) HW_AXBS_PRSn_ADDR(x, n))
#define HW_AXBS_PRSn_RD(x, n)    (HW_AXBS_PRSn(x, n).U)
#define HW_AXBS_PRSn_WR(x, n, v) (HW_AXBS_PRSn(x, n).U = (v))
#define HW_AXBS_PRSn_SET(x, n, v) (HW_AXBS_PRSn_WR(x, n, HW_AXBS_PRSn_RD(x, n) |  (v)))
#define HW_AXBS_PRSn_CLR(x, n, v) (HW_AXBS_PRSn_WR(x, n, HW_AXBS_PRSn_RD(x, n) & ~(v)))
#define HW_AXBS_PRSn_TOG(x, n, v) (HW_AXBS_PRSn_WR(x, n, HW_AXBS_PRSn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_PRSn bitfields
 */

/*!
 * @name Register AXBS_PRSn, field M0[2:0] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M0      (0U)          /*!< Bit position for AXBS_PRSn_M0. */
#define BM_AXBS_PRSn_M0      (0x00000007U) /*!< Bit mask for AXBS_PRSn_M0. */
#define BS_AXBS_PRSn_M0      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M0. */

/*! @brief Read current value of the AXBS_PRSn_M0 field. */
#define BR_AXBS_PRSn_M0(x, n) (HW_AXBS_PRSn(x, n).B.M0)

/*! @brief Format value for bitfield AXBS_PRSn_M0. */
#define BF_AXBS_PRSn_M0(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M0) & BM_AXBS_PRSn_M0)

/*! @brief Set the M0 field to a new value. */
#define BW_AXBS_PRSn_M0(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M0) | BF_AXBS_PRSn_M0(v)))
/*@}*/

/*!
 * @name Register AXBS_PRSn, field M1[6:4] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M1      (4U)          /*!< Bit position for AXBS_PRSn_M1. */
#define BM_AXBS_PRSn_M1      (0x00000070U) /*!< Bit mask for AXBS_PRSn_M1. */
#define BS_AXBS_PRSn_M1      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M1. */

/*! @brief Read current value of the AXBS_PRSn_M1 field. */
#define BR_AXBS_PRSn_M1(x, n) (HW_AXBS_PRSn(x, n).B.M1)

/*! @brief Format value for bitfield AXBS_PRSn_M1. */
#define BF_AXBS_PRSn_M1(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M1) & BM_AXBS_PRSn_M1)

/*! @brief Set the M1 field to a new value. */
#define BW_AXBS_PRSn_M1(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M1) | BF_AXBS_PRSn_M1(v)))
/*@}*/

/*!
 * @name Register AXBS_PRSn, field M2[10:8] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M2      (8U)          /*!< Bit position for AXBS_PRSn_M2. */
#define BM_AXBS_PRSn_M2      (0x00000700U) /*!< Bit mask for AXBS_PRSn_M2. */
#define BS_AXBS_PRSn_M2      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M2. */

/*! @brief Read current value of the AXBS_PRSn_M2 field. */
#define BR_AXBS_PRSn_M2(x, n) (HW_AXBS_PRSn(x, n).B.M2)

/*! @brief Format value for bitfield AXBS_PRSn_M2. */
#define BF_AXBS_PRSn_M2(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M2) & BM_AXBS_PRSn_M2)

/*! @brief Set the M2 field to a new value. */
#define BW_AXBS_PRSn_M2(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M2) | BF_AXBS_PRSn_M2(v)))
/*@}*/

/*!
 * @name Register AXBS_PRSn, field M3[14:12] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M3      (12U)         /*!< Bit position for AXBS_PRSn_M3. */
#define BM_AXBS_PRSn_M3      (0x00007000U) /*!< Bit mask for AXBS_PRSn_M3. */
#define BS_AXBS_PRSn_M3      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M3. */

/*! @brief Read current value of the AXBS_PRSn_M3 field. */
#define BR_AXBS_PRSn_M3(x, n) (HW_AXBS_PRSn(x, n).B.M3)

/*! @brief Format value for bitfield AXBS_PRSn_M3. */
#define BF_AXBS_PRSn_M3(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M3) & BM_AXBS_PRSn_M3)

/*! @brief Set the M3 field to a new value. */
#define BW_AXBS_PRSn_M3(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M3) | BF_AXBS_PRSn_M3(v)))
/*@}*/

/*!
 * @name Register AXBS_PRSn, field M4[18:16] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M4      (16U)         /*!< Bit position for AXBS_PRSn_M4. */
#define BM_AXBS_PRSn_M4      (0x00070000U) /*!< Bit mask for AXBS_PRSn_M4. */
#define BS_AXBS_PRSn_M4      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M4. */

/*! @brief Read current value of the AXBS_PRSn_M4 field. */
#define BR_AXBS_PRSn_M4(x, n) (HW_AXBS_PRSn(x, n).B.M4)

/*! @brief Format value for bitfield AXBS_PRSn_M4. */
#define BF_AXBS_PRSn_M4(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M4) & BM_AXBS_PRSn_M4)

/*! @brief Set the M4 field to a new value. */
#define BW_AXBS_PRSn_M4(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M4) | BF_AXBS_PRSn_M4(v)))
/*@}*/

/*!
 * @name Register AXBS_PRSn, field M5[22:20] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
/*@{*/
#define BP_AXBS_PRSn_M5      (20U)         /*!< Bit position for AXBS_PRSn_M5. */
#define BM_AXBS_PRSn_M5      (0x00700000U) /*!< Bit mask for AXBS_PRSn_M5. */
#define BS_AXBS_PRSn_M5      (3U)          /*!< Bit field size in bits for AXBS_PRSn_M5. */

/*! @brief Read current value of the AXBS_PRSn_M5 field. */
#define BR_AXBS_PRSn_M5(x, n) (HW_AXBS_PRSn(x, n).B.M5)

/*! @brief Format value for bitfield AXBS_PRSn_M5. */
#define BF_AXBS_PRSn_M5(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_PRSn_M5) & BM_AXBS_PRSn_M5)

/*! @brief Set the M5 field to a new value. */
#define BW_AXBS_PRSn_M5(x, n, v) (HW_AXBS_PRSn_WR(x, n, (HW_AXBS_PRSn_RD(x, n) & ~BM_AXBS_PRSn_M5) | BF_AXBS_PRSn_M5(v)))
/*@}*/
/*******************************************************************************
 * HW_AXBS_CRSn - Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_CRSn - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers control several features of each slave port and must be
 * accessed using 32-bit accesses. After CRSn[RO] is set, the PRSn can only be read;
 * attempts to write to it have no effect and result in an error response.
 */
typedef union _hw_axbs_crsn
{
    uint32_t U;
    struct _hw_axbs_crsn_bitfields
    {
        uint32_t PARK : 3;             /*!< [2:0] Park */
        uint32_t RESERVED0 : 1;        /*!< [3]  */
        uint32_t PCTL : 2;             /*!< [5:4] Parking Control */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t ARB : 2;              /*!< [9:8] Arbitration Mode */
        uint32_t RESERVED2 : 20;       /*!< [29:10]  */
        uint32_t HLP : 1;              /*!< [30] Halt Low Priority */
        uint32_t RO : 1;               /*!< [31] Read Only */
    } B;
} hw_axbs_crsn_t;

/*!
 * @name Constants and macros for entire AXBS_CRSn register
 */
/*@{*/
#define HW_AXBS_CRSn_COUNT (5U)

#define HW_AXBS_CRSn_ADDR(x, n)  ((x) + 0x10U + (0x100U * (n)))

#define HW_AXBS_CRSn(x, n)       (*(__IO hw_axbs_crsn_t *) HW_AXBS_CRSn_ADDR(x, n))
#define HW_AXBS_CRSn_RD(x, n)    (HW_AXBS_CRSn(x, n).U)
#define HW_AXBS_CRSn_WR(x, n, v) (HW_AXBS_CRSn(x, n).U = (v))
#define HW_AXBS_CRSn_SET(x, n, v) (HW_AXBS_CRSn_WR(x, n, HW_AXBS_CRSn_RD(x, n) |  (v)))
#define HW_AXBS_CRSn_CLR(x, n, v) (HW_AXBS_CRSn_WR(x, n, HW_AXBS_CRSn_RD(x, n) & ~(v)))
#define HW_AXBS_CRSn_TOG(x, n, v) (HW_AXBS_CRSn_WR(x, n, HW_AXBS_CRSn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_CRSn bitfields
 */

/*!
 * @name Register AXBS_CRSn, field PARK[2:0] (RW)
 *
 * Determines which master port the current slave port parks on when no masters
 * are actively making requests and the PCTL bits are cleared. Select only master
 * ports that are present on the chip. Otherwise, undefined behavior might occur.
 *
 * Values:
 * - 000 - Park on master port M0
 * - 001 - Park on master port M1
 * - 010 - Park on master port M2
 * - 011 - Park on master port M3
 * - 100 - Park on master port M4
 * - 101 - Park on master port M5
 * - 110 - Park on master port M6
 * - 111 - Park on master port M7
 */
/*@{*/
#define BP_AXBS_CRSn_PARK    (0U)          /*!< Bit position for AXBS_CRSn_PARK. */
#define BM_AXBS_CRSn_PARK    (0x00000007U) /*!< Bit mask for AXBS_CRSn_PARK. */
#define BS_AXBS_CRSn_PARK    (3U)          /*!< Bit field size in bits for AXBS_CRSn_PARK. */

/*! @brief Read current value of the AXBS_CRSn_PARK field. */
#define BR_AXBS_CRSn_PARK(x, n) (HW_AXBS_CRSn(x, n).B.PARK)

/*! @brief Format value for bitfield AXBS_CRSn_PARK. */
#define BF_AXBS_CRSn_PARK(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_CRSn_PARK) & BM_AXBS_CRSn_PARK)

/*! @brief Set the PARK field to a new value. */
#define BW_AXBS_CRSn_PARK(x, n, v) (HW_AXBS_CRSn_WR(x, n, (HW_AXBS_CRSn_RD(x, n) & ~BM_AXBS_CRSn_PARK) | BF_AXBS_CRSn_PARK(v)))
/*@}*/

/*!
 * @name Register AXBS_CRSn, field PCTL[5:4] (RW)
 *
 * Determines the slave port's parking control. The low-power park feature
 * results in an overall power savings if the slave port is not saturated. However,
 * this forces an extra latency clock when any master tries to access the slave
 * port while not in use because it is not parked on any master.
 *
 * Values:
 * - 00 - When no master makes a request, the arbiter parks the slave port on
 *     the master port defined by the PARK field
 * - 01 - When no master makes a request, the arbiter parks the slave port on
 *     the last master to be in control of the slave port
 * - 10 - When no master makes a request, the slave port is not parked on a
 *     master and the arbiter drives all outputs to a constant safe state
 * - 11 - Reserved
 */
/*@{*/
#define BP_AXBS_CRSn_PCTL    (4U)          /*!< Bit position for AXBS_CRSn_PCTL. */
#define BM_AXBS_CRSn_PCTL    (0x00000030U) /*!< Bit mask for AXBS_CRSn_PCTL. */
#define BS_AXBS_CRSn_PCTL    (2U)          /*!< Bit field size in bits for AXBS_CRSn_PCTL. */

/*! @brief Read current value of the AXBS_CRSn_PCTL field. */
#define BR_AXBS_CRSn_PCTL(x, n) (HW_AXBS_CRSn(x, n).B.PCTL)

/*! @brief Format value for bitfield AXBS_CRSn_PCTL. */
#define BF_AXBS_CRSn_PCTL(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_CRSn_PCTL) & BM_AXBS_CRSn_PCTL)

/*! @brief Set the PCTL field to a new value. */
#define BW_AXBS_CRSn_PCTL(x, n, v) (HW_AXBS_CRSn_WR(x, n, (HW_AXBS_CRSn_RD(x, n) & ~BM_AXBS_CRSn_PCTL) | BF_AXBS_CRSn_PCTL(v)))
/*@}*/

/*!
 * @name Register AXBS_CRSn, field ARB[9:8] (RW)
 *
 * Selects the arbitration policy for the slave port.
 *
 * Values:
 * - 00 - Fixed priority
 * - 01 - Round-robin, or rotating, priority
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
#define BP_AXBS_CRSn_ARB     (8U)          /*!< Bit position for AXBS_CRSn_ARB. */
#define BM_AXBS_CRSn_ARB     (0x00000300U) /*!< Bit mask for AXBS_CRSn_ARB. */
#define BS_AXBS_CRSn_ARB     (2U)          /*!< Bit field size in bits for AXBS_CRSn_ARB. */

/*! @brief Read current value of the AXBS_CRSn_ARB field. */
#define BR_AXBS_CRSn_ARB(x, n) (HW_AXBS_CRSn(x, n).B.ARB)

/*! @brief Format value for bitfield AXBS_CRSn_ARB. */
#define BF_AXBS_CRSn_ARB(v)  ((uint32_t)((uint32_t)(v) << BP_AXBS_CRSn_ARB) & BM_AXBS_CRSn_ARB)

/*! @brief Set the ARB field to a new value. */
#define BW_AXBS_CRSn_ARB(x, n, v) (HW_AXBS_CRSn_WR(x, n, (HW_AXBS_CRSn_RD(x, n) & ~BM_AXBS_CRSn_ARB) | BF_AXBS_CRSn_ARB(v)))
/*@}*/

/*!
 * @name Register AXBS_CRSn, field HLP[30] (RW)
 *
 * Sets the initial arbitration priority for low power mode requests . Setting
 * this bit will not affect the request for low power mode from attaining highest
 * priority once it has control of the slave ports.
 *
 * Values:
 * - 0 - The low power mode request has the highest priority for arbitration on
 *     this slave port
 * - 1 - The low power mode request has the lowest initial priority for
 *     arbitration on this slave port
 */
/*@{*/
#define BP_AXBS_CRSn_HLP     (30U)         /*!< Bit position for AXBS_CRSn_HLP. */
#define BM_AXBS_CRSn_HLP     (0x40000000U) /*!< Bit mask for AXBS_CRSn_HLP. */
#define BS_AXBS_CRSn_HLP     (1U)          /*!< Bit field size in bits for AXBS_CRSn_HLP. */

/*! @brief Read current value of the AXBS_CRSn_HLP field. */
#define BR_AXBS_CRSn_HLP(x, n) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(x, n), BP_AXBS_CRSn_HLP))

/*! @brief Format value for bitfield AXBS_CRSn_HLP. */
#define BF_AXBS_CRSn_HLP(v)  ((uint32_t)((uint32_t)(v) << BP_AXBS_CRSn_HLP) & BM_AXBS_CRSn_HLP)

/*! @brief Set the HLP field to a new value. */
#define BW_AXBS_CRSn_HLP(x, n, v) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(x, n), BP_AXBS_CRSn_HLP) = (v))
/*@}*/

/*!
 * @name Register AXBS_CRSn, field RO[31] (RW)
 *
 * Forces the slave port's CSRn and PRSn registers to be read-only. After set,
 * only a hardware reset clears it.
 *
 * Values:
 * - 0 - The slave port's registers are writeable
 * - 1 - The slave port's registers are read-only and cannot be written.
 *     Attempted writes have no effect on the registers and result in a bus error
 *     response.
 */
/*@{*/
#define BP_AXBS_CRSn_RO      (31U)         /*!< Bit position for AXBS_CRSn_RO. */
#define BM_AXBS_CRSn_RO      (0x80000000U) /*!< Bit mask for AXBS_CRSn_RO. */
#define BS_AXBS_CRSn_RO      (1U)          /*!< Bit field size in bits for AXBS_CRSn_RO. */

/*! @brief Read current value of the AXBS_CRSn_RO field. */
#define BR_AXBS_CRSn_RO(x, n) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(x, n), BP_AXBS_CRSn_RO))

/*! @brief Format value for bitfield AXBS_CRSn_RO. */
#define BF_AXBS_CRSn_RO(v)   ((uint32_t)((uint32_t)(v) << BP_AXBS_CRSn_RO) & BM_AXBS_CRSn_RO)

/*! @brief Set the RO field to a new value. */
#define BW_AXBS_CRSn_RO(x, n, v) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(x, n), BP_AXBS_CRSn_RO) = (v))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR0 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR0 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr0
{
    uint32_t U;
    struct _hw_axbs_mgpcr0_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr0_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR0 register
 */
/*@{*/
#define HW_AXBS_MGPCR0_ADDR(x)   ((x) + 0x800U)

#define HW_AXBS_MGPCR0(x)        (*(__IO hw_axbs_mgpcr0_t *) HW_AXBS_MGPCR0_ADDR(x))
#define HW_AXBS_MGPCR0_RD(x)     (HW_AXBS_MGPCR0(x).U)
#define HW_AXBS_MGPCR0_WR(x, v)  (HW_AXBS_MGPCR0(x).U = (v))
#define HW_AXBS_MGPCR0_SET(x, v) (HW_AXBS_MGPCR0_WR(x, HW_AXBS_MGPCR0_RD(x) |  (v)))
#define HW_AXBS_MGPCR0_CLR(x, v) (HW_AXBS_MGPCR0_WR(x, HW_AXBS_MGPCR0_RD(x) & ~(v)))
#define HW_AXBS_MGPCR0_TOG(x, v) (HW_AXBS_MGPCR0_WR(x, HW_AXBS_MGPCR0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR0 bitfields
 */

/*!
 * @name Register AXBS_MGPCR0, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR0_AULB  (0U)          /*!< Bit position for AXBS_MGPCR0_AULB. */
#define BM_AXBS_MGPCR0_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR0_AULB. */
#define BS_AXBS_MGPCR0_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR0_AULB. */

/*! @brief Read current value of the AXBS_MGPCR0_AULB field. */
#define BR_AXBS_MGPCR0_AULB(x) (HW_AXBS_MGPCR0(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR0_AULB. */
#define BF_AXBS_MGPCR0_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR0_AULB) & BM_AXBS_MGPCR0_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR0_AULB(x, v) (HW_AXBS_MGPCR0_WR(x, (HW_AXBS_MGPCR0_RD(x) & ~BM_AXBS_MGPCR0_AULB) | BF_AXBS_MGPCR0_AULB(v)))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR1 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR1 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr1
{
    uint32_t U;
    struct _hw_axbs_mgpcr1_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr1_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR1 register
 */
/*@{*/
#define HW_AXBS_MGPCR1_ADDR(x)   ((x) + 0x900U)

#define HW_AXBS_MGPCR1(x)        (*(__IO hw_axbs_mgpcr1_t *) HW_AXBS_MGPCR1_ADDR(x))
#define HW_AXBS_MGPCR1_RD(x)     (HW_AXBS_MGPCR1(x).U)
#define HW_AXBS_MGPCR1_WR(x, v)  (HW_AXBS_MGPCR1(x).U = (v))
#define HW_AXBS_MGPCR1_SET(x, v) (HW_AXBS_MGPCR1_WR(x, HW_AXBS_MGPCR1_RD(x) |  (v)))
#define HW_AXBS_MGPCR1_CLR(x, v) (HW_AXBS_MGPCR1_WR(x, HW_AXBS_MGPCR1_RD(x) & ~(v)))
#define HW_AXBS_MGPCR1_TOG(x, v) (HW_AXBS_MGPCR1_WR(x, HW_AXBS_MGPCR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR1 bitfields
 */

/*!
 * @name Register AXBS_MGPCR1, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR1_AULB  (0U)          /*!< Bit position for AXBS_MGPCR1_AULB. */
#define BM_AXBS_MGPCR1_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR1_AULB. */
#define BS_AXBS_MGPCR1_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR1_AULB. */

/*! @brief Read current value of the AXBS_MGPCR1_AULB field. */
#define BR_AXBS_MGPCR1_AULB(x) (HW_AXBS_MGPCR1(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR1_AULB. */
#define BF_AXBS_MGPCR1_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR1_AULB) & BM_AXBS_MGPCR1_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR1_AULB(x, v) (HW_AXBS_MGPCR1_WR(x, (HW_AXBS_MGPCR1_RD(x) & ~BM_AXBS_MGPCR1_AULB) | BF_AXBS_MGPCR1_AULB(v)))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR2 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR2 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr2
{
    uint32_t U;
    struct _hw_axbs_mgpcr2_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr2_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR2 register
 */
/*@{*/
#define HW_AXBS_MGPCR2_ADDR(x)   ((x) + 0xA00U)

#define HW_AXBS_MGPCR2(x)        (*(__IO hw_axbs_mgpcr2_t *) HW_AXBS_MGPCR2_ADDR(x))
#define HW_AXBS_MGPCR2_RD(x)     (HW_AXBS_MGPCR2(x).U)
#define HW_AXBS_MGPCR2_WR(x, v)  (HW_AXBS_MGPCR2(x).U = (v))
#define HW_AXBS_MGPCR2_SET(x, v) (HW_AXBS_MGPCR2_WR(x, HW_AXBS_MGPCR2_RD(x) |  (v)))
#define HW_AXBS_MGPCR2_CLR(x, v) (HW_AXBS_MGPCR2_WR(x, HW_AXBS_MGPCR2_RD(x) & ~(v)))
#define HW_AXBS_MGPCR2_TOG(x, v) (HW_AXBS_MGPCR2_WR(x, HW_AXBS_MGPCR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR2 bitfields
 */

/*!
 * @name Register AXBS_MGPCR2, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR2_AULB  (0U)          /*!< Bit position for AXBS_MGPCR2_AULB. */
#define BM_AXBS_MGPCR2_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR2_AULB. */
#define BS_AXBS_MGPCR2_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR2_AULB. */

/*! @brief Read current value of the AXBS_MGPCR2_AULB field. */
#define BR_AXBS_MGPCR2_AULB(x) (HW_AXBS_MGPCR2(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR2_AULB. */
#define BF_AXBS_MGPCR2_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR2_AULB) & BM_AXBS_MGPCR2_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR2_AULB(x, v) (HW_AXBS_MGPCR2_WR(x, (HW_AXBS_MGPCR2_RD(x) & ~BM_AXBS_MGPCR2_AULB) | BF_AXBS_MGPCR2_AULB(v)))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR3 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR3 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr3
{
    uint32_t U;
    struct _hw_axbs_mgpcr3_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr3_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR3 register
 */
/*@{*/
#define HW_AXBS_MGPCR3_ADDR(x)   ((x) + 0xB00U)

#define HW_AXBS_MGPCR3(x)        (*(__IO hw_axbs_mgpcr3_t *) HW_AXBS_MGPCR3_ADDR(x))
#define HW_AXBS_MGPCR3_RD(x)     (HW_AXBS_MGPCR3(x).U)
#define HW_AXBS_MGPCR3_WR(x, v)  (HW_AXBS_MGPCR3(x).U = (v))
#define HW_AXBS_MGPCR3_SET(x, v) (HW_AXBS_MGPCR3_WR(x, HW_AXBS_MGPCR3_RD(x) |  (v)))
#define HW_AXBS_MGPCR3_CLR(x, v) (HW_AXBS_MGPCR3_WR(x, HW_AXBS_MGPCR3_RD(x) & ~(v)))
#define HW_AXBS_MGPCR3_TOG(x, v) (HW_AXBS_MGPCR3_WR(x, HW_AXBS_MGPCR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR3 bitfields
 */

/*!
 * @name Register AXBS_MGPCR3, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR3_AULB  (0U)          /*!< Bit position for AXBS_MGPCR3_AULB. */
#define BM_AXBS_MGPCR3_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR3_AULB. */
#define BS_AXBS_MGPCR3_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR3_AULB. */

/*! @brief Read current value of the AXBS_MGPCR3_AULB field. */
#define BR_AXBS_MGPCR3_AULB(x) (HW_AXBS_MGPCR3(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR3_AULB. */
#define BF_AXBS_MGPCR3_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR3_AULB) & BM_AXBS_MGPCR3_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR3_AULB(x, v) (HW_AXBS_MGPCR3_WR(x, (HW_AXBS_MGPCR3_RD(x) & ~BM_AXBS_MGPCR3_AULB) | BF_AXBS_MGPCR3_AULB(v)))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR4 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR4 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr4
{
    uint32_t U;
    struct _hw_axbs_mgpcr4_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr4_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR4 register
 */
/*@{*/
#define HW_AXBS_MGPCR4_ADDR(x)   ((x) + 0xC00U)

#define HW_AXBS_MGPCR4(x)        (*(__IO hw_axbs_mgpcr4_t *) HW_AXBS_MGPCR4_ADDR(x))
#define HW_AXBS_MGPCR4_RD(x)     (HW_AXBS_MGPCR4(x).U)
#define HW_AXBS_MGPCR4_WR(x, v)  (HW_AXBS_MGPCR4(x).U = (v))
#define HW_AXBS_MGPCR4_SET(x, v) (HW_AXBS_MGPCR4_WR(x, HW_AXBS_MGPCR4_RD(x) |  (v)))
#define HW_AXBS_MGPCR4_CLR(x, v) (HW_AXBS_MGPCR4_WR(x, HW_AXBS_MGPCR4_RD(x) & ~(v)))
#define HW_AXBS_MGPCR4_TOG(x, v) (HW_AXBS_MGPCR4_WR(x, HW_AXBS_MGPCR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR4 bitfields
 */

/*!
 * @name Register AXBS_MGPCR4, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR4_AULB  (0U)          /*!< Bit position for AXBS_MGPCR4_AULB. */
#define BM_AXBS_MGPCR4_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR4_AULB. */
#define BS_AXBS_MGPCR4_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR4_AULB. */

/*! @brief Read current value of the AXBS_MGPCR4_AULB field. */
#define BR_AXBS_MGPCR4_AULB(x) (HW_AXBS_MGPCR4(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR4_AULB. */
#define BF_AXBS_MGPCR4_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR4_AULB) & BM_AXBS_MGPCR4_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR4_AULB(x, v) (HW_AXBS_MGPCR4_WR(x, (HW_AXBS_MGPCR4_RD(x) & ~BM_AXBS_MGPCR4_AULB) | BF_AXBS_MGPCR4_AULB(v)))
/*@}*/

/*******************************************************************************
 * HW_AXBS_MGPCR5 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief HW_AXBS_MGPCR5 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr5
{
    uint32_t U;
    struct _hw_axbs_mgpcr5_bitfields
    {
        uint32_t AULB : 3;             /*!< [2:0] Arbitrates On Undefined Length Bursts */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_axbs_mgpcr5_t;

/*!
 * @name Constants and macros for entire AXBS_MGPCR5 register
 */
/*@{*/
#define HW_AXBS_MGPCR5_ADDR(x)   ((x) + 0xD00U)

#define HW_AXBS_MGPCR5(x)        (*(__IO hw_axbs_mgpcr5_t *) HW_AXBS_MGPCR5_ADDR(x))
#define HW_AXBS_MGPCR5_RD(x)     (HW_AXBS_MGPCR5(x).U)
#define HW_AXBS_MGPCR5_WR(x, v)  (HW_AXBS_MGPCR5(x).U = (v))
#define HW_AXBS_MGPCR5_SET(x, v) (HW_AXBS_MGPCR5_WR(x, HW_AXBS_MGPCR5_RD(x) |  (v)))
#define HW_AXBS_MGPCR5_CLR(x, v) (HW_AXBS_MGPCR5_WR(x, HW_AXBS_MGPCR5_RD(x) & ~(v)))
#define HW_AXBS_MGPCR5_TOG(x, v) (HW_AXBS_MGPCR5_WR(x, HW_AXBS_MGPCR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR5 bitfields
 */

/*!
 * @name Register AXBS_MGPCR5, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_AXBS_MGPCR5_AULB  (0U)          /*!< Bit position for AXBS_MGPCR5_AULB. */
#define BM_AXBS_MGPCR5_AULB  (0x00000007U) /*!< Bit mask for AXBS_MGPCR5_AULB. */
#define BS_AXBS_MGPCR5_AULB  (3U)          /*!< Bit field size in bits for AXBS_MGPCR5_AULB. */

/*! @brief Read current value of the AXBS_MGPCR5_AULB field. */
#define BR_AXBS_MGPCR5_AULB(x) (HW_AXBS_MGPCR5(x).B.AULB)

/*! @brief Format value for bitfield AXBS_MGPCR5_AULB. */
#define BF_AXBS_MGPCR5_AULB(v) ((uint32_t)((uint32_t)(v) << BP_AXBS_MGPCR5_AULB) & BM_AXBS_MGPCR5_AULB)

/*! @brief Set the AULB field to a new value. */
#define BW_AXBS_MGPCR5_AULB(x, v) (HW_AXBS_MGPCR5_WR(x, (HW_AXBS_MGPCR5_RD(x) & ~BM_AXBS_MGPCR5_AULB) | BF_AXBS_MGPCR5_AULB(v)))
/*@}*/

/*******************************************************************************
 * hw_axbs_t - module struct
 ******************************************************************************/
/*!
 * @brief All AXBS module registers.
 */
#pragma pack(1)
typedef struct _hw_axbs
{
    struct {
        __IO hw_axbs_prsn_t PRSn;          /*!< [0x0] Priority Registers Slave */
        uint8_t _reserved0[12];
        __IO hw_axbs_crsn_t CRSn;          /*!< [0x10] Control Register */
        uint8_t _reserved1[236];
    } SLAVE[5];
    uint8_t _reserved0[768];
    __IO hw_axbs_mgpcr0_t MGPCR0;          /*!< [0x800] Master General Purpose Control Register */
    uint8_t _reserved1[252];
    __IO hw_axbs_mgpcr1_t MGPCR1;          /*!< [0x900] Master General Purpose Control Register */
    uint8_t _reserved2[252];
    __IO hw_axbs_mgpcr2_t MGPCR2;          /*!< [0xA00] Master General Purpose Control Register */
    uint8_t _reserved3[252];
    __IO hw_axbs_mgpcr3_t MGPCR3;          /*!< [0xB00] Master General Purpose Control Register */
    uint8_t _reserved4[252];
    __IO hw_axbs_mgpcr4_t MGPCR4;          /*!< [0xC00] Master General Purpose Control Register */
    uint8_t _reserved5[252];
    __IO hw_axbs_mgpcr5_t MGPCR5;          /*!< [0xD00] Master General Purpose Control Register */
} hw_axbs_t;
#pragma pack()

/*! @brief Macro to access all AXBS registers. */
/*! @param x AXBS module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_AXBS(AXBS_BASE)</code>. */
#define HW_AXBS(x)     (*(hw_axbs_t *)(x))

#endif /* __HW_AXBS_REGISTERS_H__ */
/* EOF */
