#ifndef MBED_MTACSERIAL_H
#define MBED_MTACSERIAL_H
 
#include "mbed.h"
namespace mts
{
    
class MTACSerial {

public:
    
    enum _slot {
        slot_1,
        slot_2
    };
    
    enum _mode {
       mode_1,
       mode_2,
       mode_3,
       mode_4 
    };
    
    MTACSerial(_slot accessory_card_slot, _mode serial_mode);
    ~MTACSerial();
    
    void test();
    
    void testLoopBack();
        
private:
    _slot slot;
    _mode mode;

    //This GPIO configure which mode the serial card will be operating in
    DigitalOut* gpio1;
    DigitalOut* gpio2;
    DigitalOut* gpio3;
    DigitalOut* gpio4;
    
    //Still working out how all these lines should be set for each mode
    DigitalOut* dtr;
    DigitalOut* rts;
    DigitalIn* ri;
    DigitalIn* cts;
    DigitalIn* dcd;
        
    Serial* mpc;
    
};

}
 
#endif