#include "MTACSerial.h"
#include "mbed.h"

using namespace mts;

MTACSerial::MTACSerial(_slot accessory_card_slot, _mode serial_mode) :
    gpio1(NULL),
    gpio2(NULL),
    gpio3(NULL),
    gpio4(NULL),
    dtr(NULL),
    dcd(NULL),
    rts(NULL),
    cts(NULL),
    ri(NULL),
    mpc(NULL)
{
    slot = accessory_card_slot;
    mode = serial_mode;

    switch (slot) {
        case slot_1:
            switch (mode){
                case mode_1:
                    //Loop Back Mode
                    gpio1 = new DigitalOut(PTB7,0);
                    gpio2 = new DigitalOut(PTB6,0);
                    break;
                
                case mode_2:
                    //RS232
                    gpio1 = new DigitalOut(PTB7,1);//1
                    gpio2 = new DigitalOut(PTB6,0);//0
                    //Need to figure out correct configuration for GPIO pins for other modes
                    gpio3 = new DigitalOut(PTB5,0);//0
                    gpio4 = new DigitalOut(PTB4,1);//1
                    break;
                
                case mode_3:
                    //RS485 Half Duplex
                    gpio1 = new DigitalOut(PTB7,0);
                    gpio2 = new DigitalOut(PTB6,1);
                    break;
                
                case mode_4:
                    //RS422-RS485 Full Duplex
                    gpio1 = new DigitalOut(PTB7,1);
                    gpio2 = new DigitalOut(PTB6,1);
                    break;
                
                default:
                    printf("invalid serial mode %d\r\n", mode);
                    return;
            }
            
            mpc = new Serial(PTD3, PTD2); //PTD3tx, PTD2rx
            mpc->baud(9600);            
            printf("serial object set\n");
            break;
            
        case slot_2:
            switch (mode){
                case mode_1:
                    //Loop Back Mode
                    gpio1 = new DigitalOut(PTA27,0);
                    gpio2 = new DigitalOut(PTA26,0);
                    break;
                
                case mode_2:
                    //RS232
                    gpio1 = new DigitalOut(PTA27,1);
                    gpio2 = new DigitalOut(PTA26,0);
                    //
                    gpio3 = new DigitalOut(PTA25,0);//0
                    gpio4 = new DigitalOut(PTA24,1);//1
                    break;
                
                case mode_3:
                    //RS485 Half Duplex
                    gpio1 = new DigitalOut(PTA27,0);
                    gpio2 = new DigitalOut(PTA26,1);
                    break;
                
                case mode_4:
                    //RS422-RS485 Full Duplex
                    gpio1 = new DigitalOut(PTA27,1);
                    gpio2 = new DigitalOut(PTA26,1);
                    break;
                
                default:
                    printf("invalid serial mode %d\r\n", mode);
                    return;
            }
            mpc = new Serial(PTB11, PTB10); //tx, rx
            mpc->baud(9600);
            break;
            
        default:
            printf("invalid slot %d\r\n", slot);
            return;
    }
}

MTACSerial::~MTACSerial() {
    if (gpio1) delete gpio1;
    if (gpio2) delete gpio2;
    if (gpio3) delete gpio3;
    if (gpio4) delete gpio4;
    if (dtr) delete dtr;
    if (mpc) delete mpc;
    if (rts) delete rts;
    if (ri) delete ri;
    if (cts) delete cts;
    if (dcd) delete dcd;
}


//Simple tests to see if configurations are working
void MTACSerial::test(){
    printf("in test function\n");
    //printf("ri = %i\n",ri->read());
    //printf("dcd = %i\n",dcd->read());
    //printf("cts = %i\n",cts->read());
    while(1) {
        printf("hello\n");
        mpc->printf("hello\n");
        wait(2);
    }
}
void MTACSerial::testLoopBack(){
    printf("in test function\n");
    printf("dtr = %i\n",dtr->read());
    //mpc->printf("%x\n", out);
    while(1) {
        printf("hello\n");
        mpc->putc('a');
        printf("%s\n",mpc->getc()+1);
        wait(2);
        //mpc->putc(mpc->getc() + 1);
    }
}
