/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef USBHOSTSOCKETMODEM_H
#define USBHOSTSOCKETMODEM_H

#include "USBHostConf.h"
#include "USBHost.h"


/** 
 * A class to communicate a USB flash disk
 */
class USBHostSocketModem : public IUSBEnumerator {
public:
    /**
     * Constructor
     *
     * @param rootdir mount name
     */
    USBHostSocketModem();

    /**
     * Check if a MSD device is connected
     *
     * @return true if a MSD device is connected
     */
    bool connected();

    /**
     * Try to connect to a MSD device
     *
     * @return true if connection was successful
     */
    bool connect();
    
    /**
     * Send AT command test function.
     *
     * Sends the "AT" command which responds with "OK" if sim card is present else "ERROR".
     */
    void testAT();

protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used
    
    //USB CDC initialization 
    virtual void setDTR();
        
private:
    USBHost * host;
    USBDeviceConnected * dev;
    bool dev_connected;
    USBEndpoint * bulk_in;
    USBEndpoint * bulk_out;
    USBEndpoint * int_in;
    USBEndpoint * int_out;
    uint8_t nb_ep;

    int sm_intf;
    int int_intf;
    int bulk_intf;
    bool sm_device_found;
    
    void init();

};

#endif
