// decodeMJPEG.cpp 2012/12/8
// decode motion-jpeg to jpeg
#include "mbed.h"
#include "decodeMJPEG.h"

#define MARK_SOF0 0xc0
#define MARK_DHT  0xc4
#define MARK_RST0 0xd0
#define MARK_RST7 0xd7
#define MARK_SOI  0xd8
#define MARK_EOI  0xd9
#define MARK_SOS  0xda
#define MARK_DQT  0xdb
#define MARK_DRI  0xdd
#define MARK_APP  0xe0
 
#define SEQ_INIT      0
#define SEQ_SOI       1
#define SEQ_FRAME     2
#define SEQ_MARK      3
#define SEQ_SEG_LEN   4
#define SEQ_SEG_LEN2  5
#define SEQ_SEG_BODY  6
#define SEQ_SOS       7
#define SEQ_SOS2      8

static const uint8_t dht[] = {
0xFF,0xC4,0x01,0xA2,0x00,0x00,0x01,0x05,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,
0x0B,0x01,0x00,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x10,0x00,
0x02,0x01,0x03,0x03,0x02,0x04,0x03,0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7D,0x01,
0x02,0x03,0x00,0x04,0x11,0x05,0x12,0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,
0x71,0x14,0x32,0x81,0x91,0xA1,0x08,0x23,0x42,0xB1,0xC1,0x15,0x52,0xD1,0xF0,0x24,
0x33,0x62,0x72,0x82,0x09,0x0A,0x16,0x17,0x18,0x19,0x1A,0x25,0x26,0x27,0x28,0x29,
0x2A,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,
0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,
0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,
0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,
0xA9,0xAA,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xC2,0xC3,0xC4,0xC5,0xC6,
0xC7,0xC8,0xC9,0xCA,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xE1,0xE2,0xE3,
0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,
0xFA,0x11,0x00,0x02,0x01,0x02,0x04,0x04,0x03,0x04,0x07,0x05,0x04,0x04,0x00,0x01,
0x02,0x77,0x00,0x01,0x02,0x03,0x11,0x04,0x05,0x21,0x31,0x06,0x12,0x41,0x51,0x07,
0x61,0x71,0x13,0x22,0x32,0x81,0x08,0x14,0x42,0x91,0xA1,0xB1,0xC1,0x09,0x23,0x33,
0x52,0xF0,0x15,0x62,0x72,0xD1,0x0A,0x16,0x24,0x34,0xE1,0x25,0xF1,0x17,0x18,0x19,
0x1A,0x26,0x27,0x28,0x29,0x2A,0x35,0x36,0x37,0x38,0x39,0x3A,0x43,0x44,0x45,0x46,
0x47,0x48,0x49,0x4A,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x63,0x64,0x65,0x66,
0x67,0x68,0x69,0x6A,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x82,0x83,0x84,0x85,
0x86,0x87,0x88,0x89,0x8A,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0xA2,0xA3,
0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,
0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,
0xD9,0xDA,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xF2,0xF3,0xF4,0xF5,0xF6,
0xF7,0xF8,0xF9,0xFA,
};

decodeMJPEG::decodeMJPEG()
{
    m_seq = SEQ_INIT;
}

void decodeMJPEG::inputPacket(const uint8_t* buf, int len)
{
    for(int i = 12; i < len; i++) {
        input(buf[i]);
    }    
}

void decodeMJPEG::input(uint8_t c)
{
    switch(m_seq) {
        case SEQ_INIT:
            if (c == 0xff) {
                m_seq = SEQ_SOI;
            }
            break;
        case SEQ_SOI:
            if (c == MARK_SOI) {
                outputJPEG(0xff, JPEG_START); // start
                outputJPEG(c);
                m_bDHT = false;
                m_seq = SEQ_FRAME;
            } else {
                m_seq = SEQ_INIT;
            }
            break;
        case SEQ_FRAME:
            if (c == 0xff) {
                m_seq = SEQ_MARK;
            } else {
                m_seq = SEQ_INIT;
            }
            break;
        case SEQ_MARK:
            if (c == MARK_SOI || c == MARK_EOI || c == 0x00) {
                m_seq = SEQ_INIT;
                break;
            }
            m_mark = c;
            m_seq = SEQ_SEG_LEN;
            break;
        case SEQ_SEG_LEN:
            m_seg_len = c;
            m_seq = SEQ_SEG_LEN2;
            break;
        case SEQ_SEG_LEN2:
            m_seg_len <<= 8;
            m_seg_len |= c;
            m_seg_len -= 2;
            m_seg_pos = 0;
            m_seq = SEQ_SEG_BODY;
            if (m_mark == MARK_SOS) {
                if (m_bDHT == false) {
                    for(int i = 0; i < sizeof(dht); i++) {
                        outputJPEG(dht[i]);
                    }    
                }
                m_output_desable = false;
            } else if (m_mark == MARK_DHT) {
                m_bDHT = true;
                m_output_desable = false;
            } else {
                m_output_desable = false;
            }
            if (!m_output_desable) {
                outputJPEG(0xff);
                outputJPEG(m_mark);
                outputJPEG((m_seg_len+2) >> 8);
                outputJPEG((m_seg_len+2) & 0xff);
            } 
            break;
        case SEQ_SEG_BODY:
            if (!m_output_desable) {
                outputJPEG(c);
            }
            if (++m_seg_pos < m_seg_len) {
                break;
            }
            if (m_mark == MARK_SOS) {
                m_seq = SEQ_SOS;
                break;
            }
            m_seq = SEQ_FRAME;
            break;
        case SEQ_SOS:
            if (c == 0xff) {
                m_seq = SEQ_SOS2;
                break;
            }
            outputJPEG(c);
            break;
        case SEQ_SOS2:
            if (c == 0x00) {
                outputJPEG(0xff);
                outputJPEG(0x00);
                m_seq = SEQ_SOS;
                break;
            } else if (c >= MARK_RST0 && c <= MARK_RST7) {
                outputJPEG(0xff);
                outputJPEG(c);
                m_seq = SEQ_SOS;
                break;
            } else if (c == MARK_EOI) {
                outputJPEG(0xff);
                outputJPEG(c, JPEG_END);
                m_seq = SEQ_INIT;
                break;
            } else if (c == MARK_SOI) {
                outputJPEG(0xff);
                outputJPEG(c);
                m_seq = SEQ_INIT;
                break;
            }
            m_seq = SEQ_INIT;
            break;
        default:
            m_seq = SEQ_INIT;
            break;
    }
}
